@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecTcpRouteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property action Action to take if a match is determined.
 * @property match Criteria for determining an gRPC request match.
 * @property timeout Types of timeouts.
 */
public data class RouteSpecTcpRouteArgs(
    public val action: Output<RouteSpecTcpRouteActionArgs>,
    public val match: Output<RouteSpecTcpRouteMatchArgs>? = null,
    public val timeout: Output<RouteSpecTcpRouteTimeoutArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecTcpRouteArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecTcpRouteArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecTcpRouteArgs.builder()
            .action(action.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .match(match?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeout(timeout?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RouteSpecTcpRouteArgs].
 */
@PulumiTagMarker
public class RouteSpecTcpRouteArgsBuilder internal constructor() {
    private var action: Output<RouteSpecTcpRouteActionArgs>? = null

    private var match: Output<RouteSpecTcpRouteMatchArgs>? = null

    private var timeout: Output<RouteSpecTcpRouteTimeoutArgs>? = null

    /**
     * @param value Action to take if a match is determined.
     */
    @JvmName("bccoqdqdjlmtlyay")
    public suspend fun action(`value`: Output<RouteSpecTcpRouteActionArgs>) {
        this.action = value
    }

    /**
     * @param value Criteria for determining an gRPC request match.
     */
    @JvmName("pgvlqsvoyrjroinb")
    public suspend fun match(`value`: Output<RouteSpecTcpRouteMatchArgs>) {
        this.match = value
    }

    /**
     * @param value Types of timeouts.
     */
    @JvmName("oghcuecvepdmfccq")
    public suspend fun timeout(`value`: Output<RouteSpecTcpRouteTimeoutArgs>) {
        this.timeout = value
    }

    /**
     * @param value Action to take if a match is determined.
     */
    @JvmName("kyclvewrlvktwqnh")
    public suspend fun action(`value`: RouteSpecTcpRouteActionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param argument Action to take if a match is determined.
     */
    @JvmName("lmjfoykgpywiwgjb")
    public suspend fun action(argument: suspend RouteSpecTcpRouteActionArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecTcpRouteActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.action = mapped
    }

    /**
     * @param value Criteria for determining an gRPC request match.
     */
    @JvmName("jqulnamyykpkhrge")
    public suspend fun match(`value`: RouteSpecTcpRouteMatchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.match = mapped
    }

    /**
     * @param argument Criteria for determining an gRPC request match.
     */
    @JvmName("qsholnmcnsmusluy")
    public suspend fun match(argument: suspend RouteSpecTcpRouteMatchArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecTcpRouteMatchArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.match = mapped
    }

    /**
     * @param value Types of timeouts.
     */
    @JvmName("vdkgobqvmmhaftwq")
    public suspend fun timeout(`value`: RouteSpecTcpRouteTimeoutArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    /**
     * @param argument Types of timeouts.
     */
    @JvmName("srxiobbogesmgpmu")
    public suspend fun timeout(argument: suspend RouteSpecTcpRouteTimeoutArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecTcpRouteTimeoutArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeout = mapped
    }

    internal fun build(): RouteSpecTcpRouteArgs = RouteSpecTcpRouteArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        match = match,
        timeout = timeout,
    )
}
