@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecTcpRouteMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property port The port number to match from the request.
 */
public data class RouteSpecTcpRouteMatchArgs(
    public val port: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecTcpRouteMatchArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecTcpRouteMatchArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecTcpRouteMatchArgs.builder()
            .port(port?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteSpecTcpRouteMatchArgs].
 */
@PulumiTagMarker
public class RouteSpecTcpRouteMatchArgsBuilder internal constructor() {
    private var port: Output<Int>? = null

    /**
     * @param value The port number to match from the request.
     */
    @JvmName("agymxdbyuewiiuwc")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The port number to match from the request.
     */
    @JvmName("htsdcuhjateqigmu")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    internal fun build(): RouteSpecTcpRouteMatchArgs = RouteSpecTcpRouteMatchArgs(
        port = port,
    )
}
