@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecBackendDefaultsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property clientPolicy Default client policy for virtual gateway backends.
 */
public data class VirtualGatewaySpecBackendDefaultsArgs(
    public val clientPolicy: Output<VirtualGatewaySpecBackendDefaultsClientPolicyArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecBackendDefaultsArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecBackendDefaultsArgs =
        com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecBackendDefaultsArgs.builder()
            .clientPolicy(clientPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualGatewaySpecBackendDefaultsArgs].
 */
@PulumiTagMarker
public class VirtualGatewaySpecBackendDefaultsArgsBuilder internal constructor() {
    private var clientPolicy: Output<VirtualGatewaySpecBackendDefaultsClientPolicyArgs>? = null

    /**
     * @param value Default client policy for virtual gateway backends.
     */
    @JvmName("fhroijaotjuynhfd")
    public suspend
    fun clientPolicy(`value`: Output<VirtualGatewaySpecBackendDefaultsClientPolicyArgs>) {
        this.clientPolicy = value
    }

    /**
     * @param value Default client policy for virtual gateway backends.
     */
    @JvmName("gksxwxgsqmddsysv")
    public suspend fun clientPolicy(`value`: VirtualGatewaySpecBackendDefaultsClientPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientPolicy = mapped
    }

    /**
     * @param argument Default client policy for virtual gateway backends.
     */
    @JvmName("ugmvfdgmuitdjvmh")
    public suspend
    fun clientPolicy(argument: suspend VirtualGatewaySpecBackendDefaultsClientPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualGatewaySpecBackendDefaultsClientPolicyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.clientPolicy = mapped
    }

    internal fun build(): VirtualGatewaySpecBackendDefaultsArgs =
        VirtualGatewaySpecBackendDefaultsArgs(
            clientPolicy = clientPolicy,
        )
}
