@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecBackendDefaultsClientPolicyTlsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property certificate Listener's TLS certificate.
 * @property enforce Whether the policy is enforced. Default is `true`.
 * @property ports One or more ports that the policy is enforced for.
 * @property validation Listener's Transport Layer Security (TLS) validation context.
 */
public data class VirtualGatewaySpecBackendDefaultsClientPolicyTlsArgs(
    public val certificate: Output<VirtualGatewaySpecBackendDefaultsClientPolicyTlsCertificateArgs>? =
        null,
    public val enforce: Output<Boolean>? = null,
    public val ports: Output<List<Int>>? = null,
    public val validation: Output<VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecBackendDefaultsClientPolicyTlsArgs> {
    override fun toJava():
        com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecBackendDefaultsClientPolicyTlsArgs =
        com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecBackendDefaultsClientPolicyTlsArgs.builder()
            .certificate(certificate?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enforce(enforce?.applyValue({ args0 -> args0 }))
            .ports(ports?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .validation(validation.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualGatewaySpecBackendDefaultsClientPolicyTlsArgs].
 */
@PulumiTagMarker
public class VirtualGatewaySpecBackendDefaultsClientPolicyTlsArgsBuilder internal constructor() {
    private var certificate: Output<VirtualGatewaySpecBackendDefaultsClientPolicyTlsCertificateArgs>? =
        null

    private var enforce: Output<Boolean>? = null

    private var ports: Output<List<Int>>? = null

    private var validation: Output<VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationArgs>? =
        null

    /**
     * @param value Listener's TLS certificate.
     */
    @JvmName("wppqptumeokexsyf")
    public suspend
    fun certificate(`value`: Output<VirtualGatewaySpecBackendDefaultsClientPolicyTlsCertificateArgs>) {
        this.certificate = value
    }

    /**
     * @param value Whether the policy is enforced. Default is `true`.
     */
    @JvmName("kvexjvpyvaucaspq")
    public suspend fun enforce(`value`: Output<Boolean>) {
        this.enforce = value
    }

    /**
     * @param value One or more ports that the policy is enforced for.
     */
    @JvmName("cmqvudqlebcwcbji")
    public suspend fun ports(`value`: Output<List<Int>>) {
        this.ports = value
    }

    @JvmName("uosmxctbdhsvhsmk")
    public suspend fun ports(vararg values: Output<Int>) {
        this.ports = Output.all(values.asList())
    }

    /**
     * @param values One or more ports that the policy is enforced for.
     */
    @JvmName("ierqaydsimdgoklu")
    public suspend fun ports(values: List<Output<Int>>) {
        this.ports = Output.all(values)
    }

    /**
     * @param value Listener's Transport Layer Security (TLS) validation context.
     */
    @JvmName("cclapsnigdaavuft")
    public suspend
    fun validation(`value`: Output<VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationArgs>) {
        this.validation = value
    }

    /**
     * @param value Listener's TLS certificate.
     */
    @JvmName("htslfmsniwwygpti")
    public suspend
    fun certificate(`value`: VirtualGatewaySpecBackendDefaultsClientPolicyTlsCertificateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificate = mapped
    }

    /**
     * @param argument Listener's TLS certificate.
     */
    @JvmName("xlbyvuxoajctvjle")
    public suspend
    fun certificate(argument: suspend VirtualGatewaySpecBackendDefaultsClientPolicyTlsCertificateArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualGatewaySpecBackendDefaultsClientPolicyTlsCertificateArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.certificate = mapped
    }

    /**
     * @param value Whether the policy is enforced. Default is `true`.
     */
    @JvmName("vlvdntulrborbrpk")
    public suspend fun enforce(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enforce = mapped
    }

    /**
     * @param value One or more ports that the policy is enforced for.
     */
    @JvmName("tywmvkonbpshvbux")
    public suspend fun ports(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    /**
     * @param values One or more ports that the policy is enforced for.
     */
    @JvmName("gpsglrbusbxykrgr")
    public suspend fun ports(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    /**
     * @param value Listener's Transport Layer Security (TLS) validation context.
     */
    @JvmName("fychwwbedttnxatj")
    public suspend
    fun validation(`value`: VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validation = mapped
    }

    /**
     * @param argument Listener's Transport Layer Security (TLS) validation context.
     */
    @JvmName("sqiwctnvnqruqhuj")
    public suspend
    fun validation(argument: suspend VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.validation = mapped
    }

    internal fun build(): VirtualGatewaySpecBackendDefaultsClientPolicyTlsArgs =
        VirtualGatewaySpecBackendDefaultsClientPolicyTlsArgs(
            certificate = certificate,
            enforce = enforce,
            ports = ports,
            validation = validation ?: throw PulumiNullFieldException("validation"),
        )
}
