@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecBackendDefaultsClientPolicyTlsCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property file Local file certificate.
 * @property sds A [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
 */
public data class VirtualGatewaySpecBackendDefaultsClientPolicyTlsCertificateArgs(
    public val `file`: Output<VirtualGatewaySpecBackendDefaultsClientPolicyTlsCertificateFileArgs>? =
        null,
    public val sds: Output<VirtualGatewaySpecBackendDefaultsClientPolicyTlsCertificateSdsArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecBackendDefaultsClientPolicyTlsCertificateArgs> {
    override fun toJava():
        com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecBackendDefaultsClientPolicyTlsCertificateArgs =
        com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecBackendDefaultsClientPolicyTlsCertificateArgs.builder()
            .`file`(`file`?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sds(sds?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualGatewaySpecBackendDefaultsClientPolicyTlsCertificateArgs].
 */
@PulumiTagMarker
public class VirtualGatewaySpecBackendDefaultsClientPolicyTlsCertificateArgsBuilder internal
constructor() {
    private var `file`: Output<VirtualGatewaySpecBackendDefaultsClientPolicyTlsCertificateFileArgs>? =
        null

    private var sds: Output<VirtualGatewaySpecBackendDefaultsClientPolicyTlsCertificateSdsArgs>? =
        null

    /**
     * @param value Local file certificate.
     */
    @JvmName("qaqwqjtqdcnbbpbc")
    public suspend
    fun `file`(`value`: Output<VirtualGatewaySpecBackendDefaultsClientPolicyTlsCertificateFileArgs>) {
        this.`file` = value
    }

    /**
     * @param value A [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
     */
    @JvmName("lxbbeytxyjtfppmt")
    public suspend
    fun sds(`value`: Output<VirtualGatewaySpecBackendDefaultsClientPolicyTlsCertificateSdsArgs>) {
        this.sds = value
    }

    /**
     * @param value Local file certificate.
     */
    @JvmName("tbknjinfdgxnpuok")
    public suspend
    fun `file`(`value`: VirtualGatewaySpecBackendDefaultsClientPolicyTlsCertificateFileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`file` = mapped
    }

    /**
     * @param argument Local file certificate.
     */
    @JvmName("yiwlowperjcdikpu")
    public suspend
    fun `file`(argument: suspend VirtualGatewaySpecBackendDefaultsClientPolicyTlsCertificateFileArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualGatewaySpecBackendDefaultsClientPolicyTlsCertificateFileArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.`file` = mapped
    }

    /**
     * @param value A [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
     */
    @JvmName("skmaiehioafaioqw")
    public suspend
    fun sds(`value`: VirtualGatewaySpecBackendDefaultsClientPolicyTlsCertificateSdsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sds = mapped
    }

    /**
     * @param argument A [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
     */
    @JvmName("nsettqqanormkkjv")
    public suspend
    fun sds(argument: suspend VirtualGatewaySpecBackendDefaultsClientPolicyTlsCertificateSdsArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualGatewaySpecBackendDefaultsClientPolicyTlsCertificateSdsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.sds = mapped
    }

    internal fun build(): VirtualGatewaySpecBackendDefaultsClientPolicyTlsCertificateArgs =
        VirtualGatewaySpecBackendDefaultsClientPolicyTlsCertificateArgs(
            `file` = `file`,
            sds = sds,
        )
}
