@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property subjectAlternativeNames SANs for a virtual gateway's listener's Transport Layer Security (TLS) validation context.
 * @property trust TLS validation context trust.
 */
public data class VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationArgs(
    public val subjectAlternativeNames:
    Output<VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationSubjectAlternativeNamesArgs>? =
        null,
    public val trust: Output<VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationArgs> {
    override fun toJava():
        com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationArgs =
        com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationArgs.builder()
            .subjectAlternativeNames(
                subjectAlternativeNames?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .trust(trust.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationArgs].
 */
@PulumiTagMarker
public class VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationArgsBuilder internal
constructor() {
    private var subjectAlternativeNames:
        Output<VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationSubjectAlternativeNamesArgs>? =
        null

    private var trust: Output<VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustArgs>? =
        null

    /**
     * @param value SANs for a virtual gateway's listener's Transport Layer Security (TLS) validation context.
     */
    @JvmName("nuxsftgdleojltpj")
    public suspend
    fun subjectAlternativeNames(`value`: Output<VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationSubjectAlternativeNamesArgs>) {
        this.subjectAlternativeNames = value
    }

    /**
     * @param value TLS validation context trust.
     */
    @JvmName("pexspjoadrirnqrv")
    public suspend
    fun trust(`value`: Output<VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustArgs>) {
        this.trust = value
    }

    /**
     * @param value SANs for a virtual gateway's listener's Transport Layer Security (TLS) validation context.
     */
    @JvmName("vlvyjbawkvglwvyo")
    public suspend
    fun subjectAlternativeNames(`value`: VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationSubjectAlternativeNamesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subjectAlternativeNames = mapped
    }

    /**
     * @param argument SANs for a virtual gateway's listener's Transport Layer Security (TLS) validation context.
     */
    @JvmName("jxunuslraptrvikh")
    public suspend
    fun subjectAlternativeNames(argument: suspend VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationSubjectAlternativeNamesArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationSubjectAlternativeNamesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.subjectAlternativeNames = mapped
    }

    /**
     * @param value TLS validation context trust.
     */
    @JvmName("mlwcjrqryggvbdsr")
    public suspend
    fun trust(`value`: VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trust = mapped
    }

    /**
     * @param argument TLS validation context trust.
     */
    @JvmName("wndencllfqdyoeoy")
    public suspend
    fun trust(argument: suspend VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.trust = mapped
    }

    internal fun build(): VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationArgs =
        VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationArgs(
            subjectAlternativeNames = subjectAlternativeNames,
            trust = trust ?: throw PulumiNullFieldException("trust"),
        )
}
