@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerConnectionPoolArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property grpc Connection pool information for gRPC listeners.
 * @property http Connection pool information for HTTP listeners.
 * @property http2 Connection pool information for HTTP2 listeners.
 */
public data class VirtualGatewaySpecListenerConnectionPoolArgs(
    public val grpc: Output<VirtualGatewaySpecListenerConnectionPoolGrpcArgs>? = null,
    public val http: Output<VirtualGatewaySpecListenerConnectionPoolHttpArgs>? = null,
    public val http2: Output<VirtualGatewaySpecListenerConnectionPoolHttp2Args>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerConnectionPoolArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerConnectionPoolArgs =
        com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerConnectionPoolArgs.builder()
            .grpc(grpc?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .http(http?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .http2(http2?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualGatewaySpecListenerConnectionPoolArgs].
 */
@PulumiTagMarker
public class VirtualGatewaySpecListenerConnectionPoolArgsBuilder internal constructor() {
    private var grpc: Output<VirtualGatewaySpecListenerConnectionPoolGrpcArgs>? = null

    private var http: Output<VirtualGatewaySpecListenerConnectionPoolHttpArgs>? = null

    private var http2: Output<VirtualGatewaySpecListenerConnectionPoolHttp2Args>? = null

    /**
     * @param value Connection pool information for gRPC listeners.
     */
    @JvmName("vrnoeopjjfeyplxu")
    public suspend fun grpc(`value`: Output<VirtualGatewaySpecListenerConnectionPoolGrpcArgs>) {
        this.grpc = value
    }

    /**
     * @param value Connection pool information for HTTP listeners.
     */
    @JvmName("pyiuxrdjphthotcy")
    public suspend fun http(`value`: Output<VirtualGatewaySpecListenerConnectionPoolHttpArgs>) {
        this.http = value
    }

    /**
     * @param value Connection pool information for HTTP2 listeners.
     */
    @JvmName("ldtrufgrobculyyw")
    public suspend fun http2(`value`: Output<VirtualGatewaySpecListenerConnectionPoolHttp2Args>) {
        this.http2 = value
    }

    /**
     * @param value Connection pool information for gRPC listeners.
     */
    @JvmName("odvcwtqcxxyyalsb")
    public suspend fun grpc(`value`: VirtualGatewaySpecListenerConnectionPoolGrpcArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grpc = mapped
    }

    /**
     * @param argument Connection pool information for gRPC listeners.
     */
    @JvmName("wjbdternlrxwtajj")
    public suspend
    fun grpc(argument: suspend VirtualGatewaySpecListenerConnectionPoolGrpcArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualGatewaySpecListenerConnectionPoolGrpcArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.grpc = mapped
    }

    /**
     * @param value Connection pool information for HTTP listeners.
     */
    @JvmName("kvpxddoxfcioirtw")
    public suspend fun http(`value`: VirtualGatewaySpecListenerConnectionPoolHttpArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.http = mapped
    }

    /**
     * @param argument Connection pool information for HTTP listeners.
     */
    @JvmName("rhyldvpqqlvqyxya")
    public suspend
    fun http(argument: suspend VirtualGatewaySpecListenerConnectionPoolHttpArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualGatewaySpecListenerConnectionPoolHttpArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.http = mapped
    }

    /**
     * @param value Connection pool information for HTTP2 listeners.
     */
    @JvmName("jtwqhaumleylmkqp")
    public suspend fun http2(`value`: VirtualGatewaySpecListenerConnectionPoolHttp2Args?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.http2 = mapped
    }

    /**
     * @param argument Connection pool information for HTTP2 listeners.
     */
    @JvmName("wkiayggbknsspahg")
    public suspend
    fun http2(argument: suspend VirtualGatewaySpecListenerConnectionPoolHttp2ArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualGatewaySpecListenerConnectionPoolHttp2ArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.http2 = mapped
    }

    internal fun build(): VirtualGatewaySpecListenerConnectionPoolArgs =
        VirtualGatewaySpecListenerConnectionPoolArgs(
            grpc = grpc,
            http = http,
            http2 = http2,
        )
}
