@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerTlsCertificateAcmArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property certificateArn ARN for the certificate.
 */
public data class VirtualGatewaySpecListenerTlsCertificateAcmArgs(
    public val certificateArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerTlsCertificateAcmArgs> {
    override fun toJava():
        com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerTlsCertificateAcmArgs =
        com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerTlsCertificateAcmArgs.builder()
            .certificateArn(certificateArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualGatewaySpecListenerTlsCertificateAcmArgs].
 */
@PulumiTagMarker
public class VirtualGatewaySpecListenerTlsCertificateAcmArgsBuilder internal constructor() {
    private var certificateArn: Output<String>? = null

    /**
     * @param value ARN for the certificate.
     */
    @JvmName("ikkovcyrbnwkdynu")
    public suspend fun certificateArn(`value`: Output<String>) {
        this.certificateArn = value
    }

    /**
     * @param value ARN for the certificate.
     */
    @JvmName("mcegbqotrdubagst")
    public suspend fun certificateArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateArn = mapped
    }

    internal fun build(): VirtualGatewaySpecListenerTlsCertificateAcmArgs =
        VirtualGatewaySpecListenerTlsCertificateAcmArgs(
            certificateArn = certificateArn ?: throw PulumiNullFieldException("certificateArn"),
        )
}
