@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerTlsValidationSubjectAlternativeNamesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property match Criteria for determining a SAN's match.
 */
public data class VirtualGatewaySpecListenerTlsValidationSubjectAlternativeNamesArgs(
    public val match: Output<VirtualGatewaySpecListenerTlsValidationSubjectAlternativeNamesMatchArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerTlsValidationSubjectAlternativeNamesArgs> {
    override fun toJava():
        com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerTlsValidationSubjectAlternativeNamesArgs =
        com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerTlsValidationSubjectAlternativeNamesArgs.builder()
            .match(match.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualGatewaySpecListenerTlsValidationSubjectAlternativeNamesArgs].
 */
@PulumiTagMarker
public class VirtualGatewaySpecListenerTlsValidationSubjectAlternativeNamesArgsBuilder internal
constructor() {
    private var match:
        Output<VirtualGatewaySpecListenerTlsValidationSubjectAlternativeNamesMatchArgs>? = null

    /**
     * @param value Criteria for determining a SAN's match.
     */
    @JvmName("yxgxdarblfkxmqnm")
    public suspend
    fun match(`value`: Output<VirtualGatewaySpecListenerTlsValidationSubjectAlternativeNamesMatchArgs>) {
        this.match = value
    }

    /**
     * @param value Criteria for determining a SAN's match.
     */
    @JvmName("pummtbqeafdnsggm")
    public suspend
    fun match(`value`: VirtualGatewaySpecListenerTlsValidationSubjectAlternativeNamesMatchArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.match = mapped
    }

    /**
     * @param argument Criteria for determining a SAN's match.
     */
    @JvmName("thaaxulfoyeuimxd")
    public suspend
    fun match(argument: suspend VirtualGatewaySpecListenerTlsValidationSubjectAlternativeNamesMatchArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualGatewaySpecListenerTlsValidationSubjectAlternativeNamesMatchArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.match = mapped
    }

    internal fun build(): VirtualGatewaySpecListenerTlsValidationSubjectAlternativeNamesArgs =
        VirtualGatewaySpecListenerTlsValidationSubjectAlternativeNamesArgs(
            match = match ?: throw PulumiNullFieldException("match"),
        )
}
