@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecLoggingAccessLogArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property file File object to send virtual gateway access logs to.
 */
public data class VirtualGatewaySpecLoggingAccessLogArgs(
    public val `file`: Output<VirtualGatewaySpecLoggingAccessLogFileArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecLoggingAccessLogArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecLoggingAccessLogArgs =
        com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecLoggingAccessLogArgs.builder()
            .`file`(`file`?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualGatewaySpecLoggingAccessLogArgs].
 */
@PulumiTagMarker
public class VirtualGatewaySpecLoggingAccessLogArgsBuilder internal constructor() {
    private var `file`: Output<VirtualGatewaySpecLoggingAccessLogFileArgs>? = null

    /**
     * @param value File object to send virtual gateway access logs to.
     */
    @JvmName("waqwodsiwhcbgdri")
    public suspend fun `file`(`value`: Output<VirtualGatewaySpecLoggingAccessLogFileArgs>) {
        this.`file` = value
    }

    /**
     * @param value File object to send virtual gateway access logs to.
     */
    @JvmName("nebkmnjajqvcvswn")
    public suspend fun `file`(`value`: VirtualGatewaySpecLoggingAccessLogFileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`file` = mapped
    }

    /**
     * @param argument File object to send virtual gateway access logs to.
     */
    @JvmName("oxfqpfpdorctfufy")
    public suspend
    fun `file`(argument: suspend VirtualGatewaySpecLoggingAccessLogFileArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualGatewaySpecLoggingAccessLogFileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.`file` = mapped
    }

    internal fun build(): VirtualGatewaySpecLoggingAccessLogArgs =
        VirtualGatewaySpecLoggingAccessLogArgs(
            `file` = `file`,
        )
}
