@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendDefaultsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property clientPolicy Default client policy for virtual service backends. See above for details.
 */
public data class VirtualNodeSpecBackendDefaultsArgs(
    public val clientPolicy: Output<VirtualNodeSpecBackendDefaultsClientPolicyArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendDefaultsArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendDefaultsArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendDefaultsArgs.builder()
            .clientPolicy(clientPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualNodeSpecBackendDefaultsArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecBackendDefaultsArgsBuilder internal constructor() {
    private var clientPolicy: Output<VirtualNodeSpecBackendDefaultsClientPolicyArgs>? = null

    /**
     * @param value Default client policy for virtual service backends. See above for details.
     */
    @JvmName("xgvpndfgwlmnuhoy")
    public suspend fun clientPolicy(`value`: Output<VirtualNodeSpecBackendDefaultsClientPolicyArgs>) {
        this.clientPolicy = value
    }

    /**
     * @param value Default client policy for virtual service backends. See above for details.
     */
    @JvmName("blgqxpdxeftppmjj")
    public suspend fun clientPolicy(`value`: VirtualNodeSpecBackendDefaultsClientPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientPolicy = mapped
    }

    /**
     * @param argument Default client policy for virtual service backends. See above for details.
     */
    @JvmName("gfapqkquauhsuqrp")
    public suspend
    fun clientPolicy(argument: suspend VirtualNodeSpecBackendDefaultsClientPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecBackendDefaultsClientPolicyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.clientPolicy = mapped
    }

    internal fun build(): VirtualNodeSpecBackendDefaultsArgs = VirtualNodeSpecBackendDefaultsArgs(
        clientPolicy = clientPolicy,
    )
}
