@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendDefaultsClientPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property tls Transport Layer Security (TLS) client policy.
 */
public data class VirtualNodeSpecBackendDefaultsClientPolicyArgs(
    public val tls: Output<VirtualNodeSpecBackendDefaultsClientPolicyTlsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendDefaultsClientPolicyArgs> {
    override fun toJava():
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendDefaultsClientPolicyArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendDefaultsClientPolicyArgs.builder()
            .tls(tls?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualNodeSpecBackendDefaultsClientPolicyArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecBackendDefaultsClientPolicyArgsBuilder internal constructor() {
    private var tls: Output<VirtualNodeSpecBackendDefaultsClientPolicyTlsArgs>? = null

    /**
     * @param value Transport Layer Security (TLS) client policy.
     */
    @JvmName("sbcegyhsgujelbkl")
    public suspend fun tls(`value`: Output<VirtualNodeSpecBackendDefaultsClientPolicyTlsArgs>) {
        this.tls = value
    }

    /**
     * @param value Transport Layer Security (TLS) client policy.
     */
    @JvmName("gwnqaviantblunhe")
    public suspend fun tls(`value`: VirtualNodeSpecBackendDefaultsClientPolicyTlsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tls = mapped
    }

    /**
     * @param argument Transport Layer Security (TLS) client policy.
     */
    @JvmName("yfwphwixmgjdvsrt")
    public suspend
    fun tls(argument: suspend VirtualNodeSpecBackendDefaultsClientPolicyTlsArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecBackendDefaultsClientPolicyTlsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.tls = mapped
    }

    internal fun build(): VirtualNodeSpecBackendDefaultsClientPolicyArgs =
        VirtualNodeSpecBackendDefaultsClientPolicyArgs(
            tls = tls,
        )
}
