@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendDefaultsClientPolicyTlsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property certificate Listener's TLS certificate.
 * @property enforce Whether the policy is enforced. Default is `true`.
 * @property ports One or more ports that the policy is enforced for.
 * @property validation Listener's Transport Layer Security (TLS) validation context.
 */
public data class VirtualNodeSpecBackendDefaultsClientPolicyTlsArgs(
    public val certificate: Output<VirtualNodeSpecBackendDefaultsClientPolicyTlsCertificateArgs>? =
        null,
    public val enforce: Output<Boolean>? = null,
    public val ports: Output<List<Int>>? = null,
    public val validation: Output<VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendDefaultsClientPolicyTlsArgs> {
    override fun toJava():
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendDefaultsClientPolicyTlsArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendDefaultsClientPolicyTlsArgs.builder()
            .certificate(certificate?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enforce(enforce?.applyValue({ args0 -> args0 }))
            .ports(ports?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .validation(validation.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualNodeSpecBackendDefaultsClientPolicyTlsArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecBackendDefaultsClientPolicyTlsArgsBuilder internal constructor() {
    private var certificate: Output<VirtualNodeSpecBackendDefaultsClientPolicyTlsCertificateArgs>? =
        null

    private var enforce: Output<Boolean>? = null

    private var ports: Output<List<Int>>? = null

    private var validation: Output<VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationArgs>? =
        null

    /**
     * @param value Listener's TLS certificate.
     */
    @JvmName("xegqqvcceywtcgnj")
    public suspend
    fun certificate(`value`: Output<VirtualNodeSpecBackendDefaultsClientPolicyTlsCertificateArgs>) {
        this.certificate = value
    }

    /**
     * @param value Whether the policy is enforced. Default is `true`.
     */
    @JvmName("mgcvuhomucfjxdfl")
    public suspend fun enforce(`value`: Output<Boolean>) {
        this.enforce = value
    }

    /**
     * @param value One or more ports that the policy is enforced for.
     */
    @JvmName("cakscsovjektbead")
    public suspend fun ports(`value`: Output<List<Int>>) {
        this.ports = value
    }

    @JvmName("lkjerovyiatqclfy")
    public suspend fun ports(vararg values: Output<Int>) {
        this.ports = Output.all(values.asList())
    }

    /**
     * @param values One or more ports that the policy is enforced for.
     */
    @JvmName("gxlagjbnvnisngpn")
    public suspend fun ports(values: List<Output<Int>>) {
        this.ports = Output.all(values)
    }

    /**
     * @param value Listener's Transport Layer Security (TLS) validation context.
     */
    @JvmName("prlurdknlhscrsim")
    public suspend
    fun validation(`value`: Output<VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationArgs>) {
        this.validation = value
    }

    /**
     * @param value Listener's TLS certificate.
     */
    @JvmName("hrxgrfhijahxgerk")
    public suspend
    fun certificate(`value`: VirtualNodeSpecBackendDefaultsClientPolicyTlsCertificateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificate = mapped
    }

    /**
     * @param argument Listener's TLS certificate.
     */
    @JvmName("owyojgiqrgwvtwkc")
    public suspend
    fun certificate(argument: suspend VirtualNodeSpecBackendDefaultsClientPolicyTlsCertificateArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualNodeSpecBackendDefaultsClientPolicyTlsCertificateArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.certificate = mapped
    }

    /**
     * @param value Whether the policy is enforced. Default is `true`.
     */
    @JvmName("tgbwvivsqgnofqlp")
    public suspend fun enforce(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enforce = mapped
    }

    /**
     * @param value One or more ports that the policy is enforced for.
     */
    @JvmName("prdbdlsauilhojix")
    public suspend fun ports(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    /**
     * @param values One or more ports that the policy is enforced for.
     */
    @JvmName("bnfafvrufeepvnwh")
    public suspend fun ports(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    /**
     * @param value Listener's Transport Layer Security (TLS) validation context.
     */
    @JvmName("jougdtpygfluqthi")
    public suspend
    fun validation(`value`: VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validation = mapped
    }

    /**
     * @param argument Listener's Transport Layer Security (TLS) validation context.
     */
    @JvmName("slhvfemyexdhetbf")
    public suspend
    fun validation(argument: suspend VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.validation = mapped
    }

    internal fun build(): VirtualNodeSpecBackendDefaultsClientPolicyTlsArgs =
        VirtualNodeSpecBackendDefaultsClientPolicyTlsArgs(
            certificate = certificate,
            enforce = enforce,
            ports = ports,
            validation = validation ?: throw PulumiNullFieldException("validation"),
        )
}
