@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property clientPolicy Client policy for the backend.
 * @property virtualServiceName Name of the virtual service that is acting as a virtual node backend. Must be between 1 and 255 characters in length.
 */
public data class VirtualNodeSpecBackendVirtualServiceArgs(
    public val clientPolicy: Output<VirtualNodeSpecBackendVirtualServiceClientPolicyArgs>? = null,
    public val virtualServiceName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceArgs.builder()
            .clientPolicy(clientPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .virtualServiceName(virtualServiceName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNodeSpecBackendVirtualServiceArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecBackendVirtualServiceArgsBuilder internal constructor() {
    private var clientPolicy: Output<VirtualNodeSpecBackendVirtualServiceClientPolicyArgs>? = null

    private var virtualServiceName: Output<String>? = null

    /**
     * @param value Client policy for the backend.
     */
    @JvmName("estnjxlbgjxgyfwx")
    public suspend
    fun clientPolicy(`value`: Output<VirtualNodeSpecBackendVirtualServiceClientPolicyArgs>) {
        this.clientPolicy = value
    }

    /**
     * @param value Name of the virtual service that is acting as a virtual node backend. Must be between 1 and 255 characters in length.
     */
    @JvmName("tvvswolkvrehpmdu")
    public suspend fun virtualServiceName(`value`: Output<String>) {
        this.virtualServiceName = value
    }

    /**
     * @param value Client policy for the backend.
     */
    @JvmName("ctvecjyieripvsfk")
    public suspend fun clientPolicy(`value`: VirtualNodeSpecBackendVirtualServiceClientPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientPolicy = mapped
    }

    /**
     * @param argument Client policy for the backend.
     */
    @JvmName("hemuklnjhekyasfh")
    public suspend
    fun clientPolicy(argument: suspend VirtualNodeSpecBackendVirtualServiceClientPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecBackendVirtualServiceClientPolicyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.clientPolicy = mapped
    }

    /**
     * @param value Name of the virtual service that is acting as a virtual node backend. Must be between 1 and 255 characters in length.
     */
    @JvmName("dswmqygsakyciqrt")
    public suspend fun virtualServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualServiceName = mapped
    }

    internal fun build(): VirtualNodeSpecBackendVirtualServiceArgs =
        VirtualNodeSpecBackendVirtualServiceArgs(
            clientPolicy = clientPolicy,
            virtualServiceName = virtualServiceName ?: throw PulumiNullFieldException("virtualServiceName"),
        )
}
