@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceClientPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property tls Transport Layer Security (TLS) client policy.
 */
public data class VirtualNodeSpecBackendVirtualServiceClientPolicyArgs(
    public val tls: Output<VirtualNodeSpecBackendVirtualServiceClientPolicyTlsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceClientPolicyArgs> {
    override fun toJava():
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceClientPolicyArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceClientPolicyArgs.builder()
            .tls(tls?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualNodeSpecBackendVirtualServiceClientPolicyArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecBackendVirtualServiceClientPolicyArgsBuilder internal constructor() {
    private var tls: Output<VirtualNodeSpecBackendVirtualServiceClientPolicyTlsArgs>? = null

    /**
     * @param value Transport Layer Security (TLS) client policy.
     */
    @JvmName("yihljfsdhsuguonl")
    public suspend fun tls(`value`: Output<VirtualNodeSpecBackendVirtualServiceClientPolicyTlsArgs>) {
        this.tls = value
    }

    /**
     * @param value Transport Layer Security (TLS) client policy.
     */
    @JvmName("nssytvfkhwlrkhjp")
    public suspend fun tls(`value`: VirtualNodeSpecBackendVirtualServiceClientPolicyTlsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tls = mapped
    }

    /**
     * @param argument Transport Layer Security (TLS) client policy.
     */
    @JvmName("yampftwdyhxwxnvn")
    public suspend
    fun tls(argument: suspend VirtualNodeSpecBackendVirtualServiceClientPolicyTlsArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecBackendVirtualServiceClientPolicyTlsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.tls = mapped
    }

    internal fun build(): VirtualNodeSpecBackendVirtualServiceClientPolicyArgs =
        VirtualNodeSpecBackendVirtualServiceClientPolicyArgs(
            tls = tls,
        )
}
