@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceClientPolicyTlsCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property file Local file certificate.
 * @property sds A [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
 */
public data class VirtualNodeSpecBackendVirtualServiceClientPolicyTlsCertificateArgs(
    public val `file`: Output<VirtualNodeSpecBackendVirtualServiceClientPolicyTlsCertificateFileArgs>? =
        null,
    public val sds: Output<VirtualNodeSpecBackendVirtualServiceClientPolicyTlsCertificateSdsArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceClientPolicyTlsCertificateArgs> {
    override fun toJava():
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceClientPolicyTlsCertificateArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceClientPolicyTlsCertificateArgs.builder()
            .`file`(`file`?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sds(sds?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualNodeSpecBackendVirtualServiceClientPolicyTlsCertificateArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecBackendVirtualServiceClientPolicyTlsCertificateArgsBuilder internal
constructor() {
    private var `file`:
        Output<VirtualNodeSpecBackendVirtualServiceClientPolicyTlsCertificateFileArgs>? = null

    private var sds: Output<VirtualNodeSpecBackendVirtualServiceClientPolicyTlsCertificateSdsArgs>? =
        null

    /**
     * @param value Local file certificate.
     */
    @JvmName("dhvopbfkopiyyksl")
    public suspend
    fun `file`(`value`: Output<VirtualNodeSpecBackendVirtualServiceClientPolicyTlsCertificateFileArgs>) {
        this.`file` = value
    }

    /**
     * @param value A [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
     */
    @JvmName("noidvjtqpcfagnwl")
    public suspend
    fun sds(`value`: Output<VirtualNodeSpecBackendVirtualServiceClientPolicyTlsCertificateSdsArgs>) {
        this.sds = value
    }

    /**
     * @param value Local file certificate.
     */
    @JvmName("ohngcolrcmxhvppj")
    public suspend
    fun `file`(`value`: VirtualNodeSpecBackendVirtualServiceClientPolicyTlsCertificateFileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`file` = mapped
    }

    /**
     * @param argument Local file certificate.
     */
    @JvmName("coffbqyunsaccqqd")
    public suspend
    fun `file`(argument: suspend VirtualNodeSpecBackendVirtualServiceClientPolicyTlsCertificateFileArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualNodeSpecBackendVirtualServiceClientPolicyTlsCertificateFileArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.`file` = mapped
    }

    /**
     * @param value A [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
     */
    @JvmName("lxctjkuavepbinkg")
    public suspend
    fun sds(`value`: VirtualNodeSpecBackendVirtualServiceClientPolicyTlsCertificateSdsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sds = mapped
    }

    /**
     * @param argument A [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
     */
    @JvmName("aonkmcuktxlgpvji")
    public suspend
    fun sds(argument: suspend VirtualNodeSpecBackendVirtualServiceClientPolicyTlsCertificateSdsArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualNodeSpecBackendVirtualServiceClientPolicyTlsCertificateSdsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.sds = mapped
    }

    internal fun build(): VirtualNodeSpecBackendVirtualServiceClientPolicyTlsCertificateArgs =
        VirtualNodeSpecBackendVirtualServiceClientPolicyTlsCertificateArgs(
            `file` = `file`,
            sds = sds,
        )
}
