@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property subjectAlternativeNames SANs for a TLS validation context.
 * @property trust TLS validation context trust.
 */
public data class VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationArgs(
    public val subjectAlternativeNames:
    Output<VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationSubjectAlternativeNamesArgs>? =
        null,
    public val trust: Output<VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationArgs> {
    override fun toJava():
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationArgs.builder()
            .subjectAlternativeNames(
                subjectAlternativeNames?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .trust(trust.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationArgsBuilder internal
constructor() {
    private var subjectAlternativeNames:
        Output<VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationSubjectAlternativeNamesArgs>? =
        null

    private var trust: Output<VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustArgs>? =
        null

    /**
     * @param value SANs for a TLS validation context.
     */
    @JvmName("ypqpwldpakjlraiw")
    public suspend
    fun subjectAlternativeNames(`value`: Output<VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationSubjectAlternativeNamesArgs>) {
        this.subjectAlternativeNames = value
    }

    /**
     * @param value TLS validation context trust.
     */
    @JvmName("csbfcwrayyirruws")
    public suspend
    fun trust(`value`: Output<VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustArgs>) {
        this.trust = value
    }

    /**
     * @param value SANs for a TLS validation context.
     */
    @JvmName("wqwjehsbqoktidrb")
    public suspend
    fun subjectAlternativeNames(`value`: VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationSubjectAlternativeNamesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subjectAlternativeNames = mapped
    }

    /**
     * @param argument SANs for a TLS validation context.
     */
    @JvmName("annmppilwqtnwkmk")
    public suspend
    fun subjectAlternativeNames(argument: suspend VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationSubjectAlternativeNamesArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationSubjectAlternativeNamesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.subjectAlternativeNames = mapped
    }

    /**
     * @param value TLS validation context trust.
     */
    @JvmName("hhirutvipyevxput")
    public suspend
    fun trust(`value`: VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trust = mapped
    }

    /**
     * @param argument TLS validation context trust.
     */
    @JvmName("ktiklkjdfhbkncwh")
    public suspend
    fun trust(argument: suspend VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.trust = mapped
    }

    internal fun build(): VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationArgs =
        VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationArgs(
            subjectAlternativeNames = subjectAlternativeNames,
            trust = trust ?: throw PulumiNullFieldException("trust"),
        )
}
