@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property acm TLS validation context trust for an AWS Certificate Manager (ACM) certificate.
 * @property file TLS validation context trust for a local file certificate.
 * @property sds TLS validation context trust for a [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
 */
public data class VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustArgs(
    public val acm: Output<VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustAcmArgs>? =
        null,
    public val `file`:
    Output<VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustFileArgs>? = null,
    public val sds: Output<VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustSdsArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustArgs> {
    override fun toJava():
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustArgs.builder()
            .acm(acm?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .`file`(`file`?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sds(sds?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustArgsBuilder internal
constructor() {
    private var acm:
        Output<VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustAcmArgs>? = null

    private var `file`:
        Output<VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustFileArgs>? = null

    private var sds:
        Output<VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustSdsArgs>? = null

    /**
     * @param value TLS validation context trust for an AWS Certificate Manager (ACM) certificate.
     */
    @JvmName("xocmogiifloqqgpy")
    public suspend
    fun acm(`value`: Output<VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustAcmArgs>) {
        this.acm = value
    }

    /**
     * @param value TLS validation context trust for a local file certificate.
     */
    @JvmName("fqmlmwsdkncmlmek")
    public suspend
    fun `file`(`value`: Output<VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustFileArgs>) {
        this.`file` = value
    }

    /**
     * @param value TLS validation context trust for a [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
     */
    @JvmName("nhfwaxmvxagkubuu")
    public suspend
    fun sds(`value`: Output<VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustSdsArgs>) {
        this.sds = value
    }

    /**
     * @param value TLS validation context trust for an AWS Certificate Manager (ACM) certificate.
     */
    @JvmName("rfomkooaiwpbsnra")
    public suspend
    fun acm(`value`: VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustAcmArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acm = mapped
    }

    /**
     * @param argument TLS validation context trust for an AWS Certificate Manager (ACM) certificate.
     */
    @JvmName("djotqpijrpfrnjfn")
    public suspend
    fun acm(argument: suspend VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustAcmArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustAcmArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.acm = mapped
    }

    /**
     * @param value TLS validation context trust for a local file certificate.
     */
    @JvmName("yfcvjucglpnxvelm")
    public suspend
    fun `file`(`value`: VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustFileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`file` = mapped
    }

    /**
     * @param argument TLS validation context trust for a local file certificate.
     */
    @JvmName("gubmxwwybtrfysjs")
    public suspend
    fun `file`(argument: suspend VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustFileArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustFileArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.`file` = mapped
    }

    /**
     * @param value TLS validation context trust for a [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
     */
    @JvmName("obhjuigyevqfhslr")
    public suspend
    fun sds(`value`: VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustSdsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sds = mapped
    }

    /**
     * @param argument TLS validation context trust for a [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
     */
    @JvmName("hqrhsyigshftkjbc")
    public suspend
    fun sds(argument: suspend VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustSdsArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustSdsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.sds = mapped
    }

    internal fun build(): VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustArgs =
        VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustArgs(
            acm = acm,
            `file` = `file`,
            sds = sds,
        )
}
