@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustSdsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property secretName Name of the secret for a virtual node's Transport Layer Security (TLS) Secret Discovery Service validation context trust.
 */
public data class VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustSdsArgs(
    public val secretName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustSdsArgs> {
    override fun toJava():
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustSdsArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustSdsArgs.builder()
            .secretName(secretName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustSdsArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustSdsArgsBuilder
internal constructor() {
    private var secretName: Output<String>? = null

    /**
     * @param value Name of the secret for a virtual node's Transport Layer Security (TLS) Secret Discovery Service validation context trust.
     */
    @JvmName("hycytdawpubpduch")
    public suspend fun secretName(`value`: Output<String>) {
        this.secretName = value
    }

    /**
     * @param value Name of the secret for a virtual node's Transport Layer Security (TLS) Secret Discovery Service validation context trust.
     */
    @JvmName("vepykoxnaihjyboi")
    public suspend fun secretName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretName = mapped
    }

    internal fun build(): VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustSdsArgs =
        VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustSdsArgs(
            secretName = secretName ?: throw PulumiNullFieldException("secretName"),
        )
}
