@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property connectionPool Connection pool information for the listener.
 * @property healthCheck Health check information for the listener.
 * @property outlierDetection Outlier detection information for the listener.
 * @property portMapping Port mapping information for the listener.
 * @property timeout Timeouts for different protocols.
 * @property tls Transport Layer Security (TLS) properties for the listener
 */
public data class VirtualNodeSpecListenerArgs(
    public val connectionPool: Output<VirtualNodeSpecListenerConnectionPoolArgs>? = null,
    public val healthCheck: Output<VirtualNodeSpecListenerHealthCheckArgs>? = null,
    public val outlierDetection: Output<VirtualNodeSpecListenerOutlierDetectionArgs>? = null,
    public val portMapping: Output<VirtualNodeSpecListenerPortMappingArgs>,
    public val timeout: Output<VirtualNodeSpecListenerTimeoutArgs>? = null,
    public val tls: Output<VirtualNodeSpecListenerTlsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerArgs.builder()
            .connectionPool(connectionPool?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .healthCheck(healthCheck?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .outlierDetection(outlierDetection?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .portMapping(portMapping.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeout(timeout?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tls(tls?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualNodeSpecListenerArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecListenerArgsBuilder internal constructor() {
    private var connectionPool: Output<VirtualNodeSpecListenerConnectionPoolArgs>? = null

    private var healthCheck: Output<VirtualNodeSpecListenerHealthCheckArgs>? = null

    private var outlierDetection: Output<VirtualNodeSpecListenerOutlierDetectionArgs>? = null

    private var portMapping: Output<VirtualNodeSpecListenerPortMappingArgs>? = null

    private var timeout: Output<VirtualNodeSpecListenerTimeoutArgs>? = null

    private var tls: Output<VirtualNodeSpecListenerTlsArgs>? = null

    /**
     * @param value Connection pool information for the listener.
     */
    @JvmName("jcmjknyayxfaujng")
    public suspend fun connectionPool(`value`: Output<VirtualNodeSpecListenerConnectionPoolArgs>) {
        this.connectionPool = value
    }

    /**
     * @param value Health check information for the listener.
     */
    @JvmName("jcqcmxgmvrvkqdxe")
    public suspend fun healthCheck(`value`: Output<VirtualNodeSpecListenerHealthCheckArgs>) {
        this.healthCheck = value
    }

    /**
     * @param value Outlier detection information for the listener.
     */
    @JvmName("hokufodfrmxcxgwu")
    public suspend
    fun outlierDetection(`value`: Output<VirtualNodeSpecListenerOutlierDetectionArgs>) {
        this.outlierDetection = value
    }

    /**
     * @param value Port mapping information for the listener.
     */
    @JvmName("qjnixnebjjlukhoa")
    public suspend fun portMapping(`value`: Output<VirtualNodeSpecListenerPortMappingArgs>) {
        this.portMapping = value
    }

    /**
     * @param value Timeouts for different protocols.
     */
    @JvmName("cefjsnogcatskclh")
    public suspend fun timeout(`value`: Output<VirtualNodeSpecListenerTimeoutArgs>) {
        this.timeout = value
    }

    /**
     * @param value Transport Layer Security (TLS) properties for the listener
     */
    @JvmName("jogyrrqjmstislkb")
    public suspend fun tls(`value`: Output<VirtualNodeSpecListenerTlsArgs>) {
        this.tls = value
    }

    /**
     * @param value Connection pool information for the listener.
     */
    @JvmName("aonhgxebbhrjllep")
    public suspend fun connectionPool(`value`: VirtualNodeSpecListenerConnectionPoolArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionPool = mapped
    }

    /**
     * @param argument Connection pool information for the listener.
     */
    @JvmName("nwatmfgrvrtvaaeo")
    public suspend
    fun connectionPool(argument: suspend VirtualNodeSpecListenerConnectionPoolArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecListenerConnectionPoolArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.connectionPool = mapped
    }

    /**
     * @param value Health check information for the listener.
     */
    @JvmName("owfojttajdiyisww")
    public suspend fun healthCheck(`value`: VirtualNodeSpecListenerHealthCheckArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheck = mapped
    }

    /**
     * @param argument Health check information for the listener.
     */
    @JvmName("lwosdacgnnstjrqy")
    public suspend
    fun healthCheck(argument: suspend VirtualNodeSpecListenerHealthCheckArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecListenerHealthCheckArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.healthCheck = mapped
    }

    /**
     * @param value Outlier detection information for the listener.
     */
    @JvmName("sxvnceijksgqgsaw")
    public suspend fun outlierDetection(`value`: VirtualNodeSpecListenerOutlierDetectionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outlierDetection = mapped
    }

    /**
     * @param argument Outlier detection information for the listener.
     */
    @JvmName("mvkduetpsuwkykbo")
    public suspend
    fun outlierDetection(argument: suspend VirtualNodeSpecListenerOutlierDetectionArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecListenerOutlierDetectionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.outlierDetection = mapped
    }

    /**
     * @param value Port mapping information for the listener.
     */
    @JvmName("ygcuajivvkyrxtvy")
    public suspend fun portMapping(`value`: VirtualNodeSpecListenerPortMappingArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.portMapping = mapped
    }

    /**
     * @param argument Port mapping information for the listener.
     */
    @JvmName("tkrllqsgrwqnhosk")
    public suspend
    fun portMapping(argument: suspend VirtualNodeSpecListenerPortMappingArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecListenerPortMappingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.portMapping = mapped
    }

    /**
     * @param value Timeouts for different protocols.
     */
    @JvmName("tkmmpdpjcekqapiv")
    public suspend fun timeout(`value`: VirtualNodeSpecListenerTimeoutArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    /**
     * @param argument Timeouts for different protocols.
     */
    @JvmName("avkoxitynkodhfun")
    public suspend
    fun timeout(argument: suspend VirtualNodeSpecListenerTimeoutArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecListenerTimeoutArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeout = mapped
    }

    /**
     * @param value Transport Layer Security (TLS) properties for the listener
     */
    @JvmName("jvhhetoregtkmlkd")
    public suspend fun tls(`value`: VirtualNodeSpecListenerTlsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tls = mapped
    }

    /**
     * @param argument Transport Layer Security (TLS) properties for the listener
     */
    @JvmName("bibgjijljpetdybn")
    public suspend fun tls(argument: suspend VirtualNodeSpecListenerTlsArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecListenerTlsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tls = mapped
    }

    internal fun build(): VirtualNodeSpecListenerArgs = VirtualNodeSpecListenerArgs(
        connectionPool = connectionPool,
        healthCheck = healthCheck,
        outlierDetection = outlierDetection,
        portMapping = portMapping ?: throw PulumiNullFieldException("portMapping"),
        timeout = timeout,
        tls = tls,
    )
}
