@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerConnectionPoolArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property grpc Connection pool information for gRPC listeners.
 * @property http2s Connection pool information for HTTP2 listeners.
 * @property https Connection pool information for HTTP listeners.
 * @property tcps Connection pool information for TCP listeners.
 */
public data class VirtualNodeSpecListenerConnectionPoolArgs(
    public val grpc: Output<VirtualNodeSpecListenerConnectionPoolGrpcArgs>? = null,
    public val http2s: Output<List<VirtualNodeSpecListenerConnectionPoolHttp2Args>>? = null,
    public val https: Output<List<VirtualNodeSpecListenerConnectionPoolHttpArgs>>? = null,
    public val tcps: Output<List<VirtualNodeSpecListenerConnectionPoolTcpArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerConnectionPoolArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerConnectionPoolArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerConnectionPoolArgs.builder()
            .grpc(grpc?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .http2s(http2s?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .https(https?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tcps(
                tcps?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualNodeSpecListenerConnectionPoolArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecListenerConnectionPoolArgsBuilder internal constructor() {
    private var grpc: Output<VirtualNodeSpecListenerConnectionPoolGrpcArgs>? = null

    private var http2s: Output<List<VirtualNodeSpecListenerConnectionPoolHttp2Args>>? = null

    private var https: Output<List<VirtualNodeSpecListenerConnectionPoolHttpArgs>>? = null

    private var tcps: Output<List<VirtualNodeSpecListenerConnectionPoolTcpArgs>>? = null

    /**
     * @param value Connection pool information for gRPC listeners.
     */
    @JvmName("hpwnhoriroltvswh")
    public suspend fun grpc(`value`: Output<VirtualNodeSpecListenerConnectionPoolGrpcArgs>) {
        this.grpc = value
    }

    /**
     * @param value Connection pool information for HTTP2 listeners.
     */
    @JvmName("ohjgllvofdojkgce")
    public suspend fun http2s(`value`: Output<List<VirtualNodeSpecListenerConnectionPoolHttp2Args>>) {
        this.http2s = value
    }

    @JvmName("rmexiyearyuvevwx")
    public suspend fun http2s(vararg values: Output<VirtualNodeSpecListenerConnectionPoolHttp2Args>) {
        this.http2s = Output.all(values.asList())
    }

    /**
     * @param values Connection pool information for HTTP2 listeners.
     */
    @JvmName("xtbmhqxxkbkhymyx")
    public suspend fun http2s(values: List<Output<VirtualNodeSpecListenerConnectionPoolHttp2Args>>) {
        this.http2s = Output.all(values)
    }

    /**
     * @param value Connection pool information for HTTP listeners.
     */
    @JvmName("qnoggfohietydhlv")
    public suspend fun https(`value`: Output<List<VirtualNodeSpecListenerConnectionPoolHttpArgs>>) {
        this.https = value
    }

    @JvmName("epgaxfpoydjdbxdi")
    public suspend fun https(vararg values: Output<VirtualNodeSpecListenerConnectionPoolHttpArgs>) {
        this.https = Output.all(values.asList())
    }

    /**
     * @param values Connection pool information for HTTP listeners.
     */
    @JvmName("pphjbcveqamocmdg")
    public suspend fun https(values: List<Output<VirtualNodeSpecListenerConnectionPoolHttpArgs>>) {
        this.https = Output.all(values)
    }

    /**
     * @param value Connection pool information for TCP listeners.
     */
    @JvmName("ypegwvgqxdsriycw")
    public suspend fun tcps(`value`: Output<List<VirtualNodeSpecListenerConnectionPoolTcpArgs>>) {
        this.tcps = value
    }

    @JvmName("jmsuvsjnitpqshvr")
    public suspend fun tcps(vararg values: Output<VirtualNodeSpecListenerConnectionPoolTcpArgs>) {
        this.tcps = Output.all(values.asList())
    }

    /**
     * @param values Connection pool information for TCP listeners.
     */
    @JvmName("lgvgoatbwspckteq")
    public suspend fun tcps(values: List<Output<VirtualNodeSpecListenerConnectionPoolTcpArgs>>) {
        this.tcps = Output.all(values)
    }

    /**
     * @param value Connection pool information for gRPC listeners.
     */
    @JvmName("ydhgliannvckktuf")
    public suspend fun grpc(`value`: VirtualNodeSpecListenerConnectionPoolGrpcArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grpc = mapped
    }

    /**
     * @param argument Connection pool information for gRPC listeners.
     */
    @JvmName("encnqhqnfxvqskwt")
    public suspend
    fun grpc(argument: suspend VirtualNodeSpecListenerConnectionPoolGrpcArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecListenerConnectionPoolGrpcArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.grpc = mapped
    }

    /**
     * @param value Connection pool information for HTTP2 listeners.
     */
    @JvmName("orevuxikmgswbfqk")
    public suspend fun http2s(`value`: List<VirtualNodeSpecListenerConnectionPoolHttp2Args>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.http2s = mapped
    }

    /**
     * @param argument Connection pool information for HTTP2 listeners.
     */
    @JvmName("fdgyawcvvuqwytpp")
    public suspend
    fun http2s(argument: List<suspend VirtualNodeSpecListenerConnectionPoolHttp2ArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualNodeSpecListenerConnectionPoolHttp2ArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.http2s = mapped
    }

    /**
     * @param argument Connection pool information for HTTP2 listeners.
     */
    @JvmName("uxshhkcbtswdaqlw")
    public suspend fun http2s(
        vararg
        argument: suspend VirtualNodeSpecListenerConnectionPoolHttp2ArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualNodeSpecListenerConnectionPoolHttp2ArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.http2s = mapped
    }

    /**
     * @param argument Connection pool information for HTTP2 listeners.
     */
    @JvmName("yllyqkjeififfife")
    public suspend
    fun http2s(argument: suspend VirtualNodeSpecListenerConnectionPoolHttp2ArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualNodeSpecListenerConnectionPoolHttp2ArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.http2s = mapped
    }

    /**
     * @param values Connection pool information for HTTP2 listeners.
     */
    @JvmName("maogrmspnklixhel")
    public suspend fun http2s(vararg values: VirtualNodeSpecListenerConnectionPoolHttp2Args) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.http2s = mapped
    }

    /**
     * @param value Connection pool information for HTTP listeners.
     */
    @JvmName("dglninxrqrenlegi")
    public suspend fun https(`value`: List<VirtualNodeSpecListenerConnectionPoolHttpArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.https = mapped
    }

    /**
     * @param argument Connection pool information for HTTP listeners.
     */
    @JvmName("okudmwmrfufrcccf")
    public suspend
    fun https(argument: List<suspend VirtualNodeSpecListenerConnectionPoolHttpArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualNodeSpecListenerConnectionPoolHttpArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.https = mapped
    }

    /**
     * @param argument Connection pool information for HTTP listeners.
     */
    @JvmName("mpibegxsqotpnjkt")
    public suspend fun https(
        vararg
        argument: suspend VirtualNodeSpecListenerConnectionPoolHttpArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualNodeSpecListenerConnectionPoolHttpArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.https = mapped
    }

    /**
     * @param argument Connection pool information for HTTP listeners.
     */
    @JvmName("neybckvyegcpfshv")
    public suspend
    fun https(argument: suspend VirtualNodeSpecListenerConnectionPoolHttpArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualNodeSpecListenerConnectionPoolHttpArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.https = mapped
    }

    /**
     * @param values Connection pool information for HTTP listeners.
     */
    @JvmName("qcbruogksyejjwqy")
    public suspend fun https(vararg values: VirtualNodeSpecListenerConnectionPoolHttpArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.https = mapped
    }

    /**
     * @param value Connection pool information for TCP listeners.
     */
    @JvmName("qbrnlgdbogjvxmpd")
    public suspend fun tcps(`value`: List<VirtualNodeSpecListenerConnectionPoolTcpArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tcps = mapped
    }

    /**
     * @param argument Connection pool information for TCP listeners.
     */
    @JvmName("lnokbcgeeufapkir")
    public suspend
    fun tcps(argument: List<suspend VirtualNodeSpecListenerConnectionPoolTcpArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualNodeSpecListenerConnectionPoolTcpArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.tcps = mapped
    }

    /**
     * @param argument Connection pool information for TCP listeners.
     */
    @JvmName("oujmsggpnkehelwn")
    public suspend fun tcps(
        vararg
        argument: suspend VirtualNodeSpecListenerConnectionPoolTcpArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualNodeSpecListenerConnectionPoolTcpArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.tcps = mapped
    }

    /**
     * @param argument Connection pool information for TCP listeners.
     */
    @JvmName("nsltjseqmwccahwm")
    public suspend
    fun tcps(argument: suspend VirtualNodeSpecListenerConnectionPoolTcpArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualNodeSpecListenerConnectionPoolTcpArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.tcps = mapped
    }

    /**
     * @param values Connection pool information for TCP listeners.
     */
    @JvmName("jnttgmrdcdqkpwlg")
    public suspend fun tcps(vararg values: VirtualNodeSpecListenerConnectionPoolTcpArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tcps = mapped
    }

    internal fun build(): VirtualNodeSpecListenerConnectionPoolArgs =
        VirtualNodeSpecListenerConnectionPoolArgs(
            grpc = grpc,
            http2s = http2s,
            https = https,
            tcps = tcps,
        )
}
