@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerOutlierDetectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property baseEjectionDuration Base amount of time for which a host is ejected.
 * @property interval Time interval between ejection sweep analysis.
 * @property maxEjectionPercent Maximum percentage of hosts in load balancing pool for upstream service that can be ejected. Will eject at least one host regardless of the value.
 * Minimum value of `0`. Maximum value of `100`.
 * @property maxServerErrors Number of consecutive `5xx` errors required for ejection. Minimum value of `1`.
 */
public data class VirtualNodeSpecListenerOutlierDetectionArgs(
    public val baseEjectionDuration:
    Output<VirtualNodeSpecListenerOutlierDetectionBaseEjectionDurationArgs>,
    public val interval: Output<VirtualNodeSpecListenerOutlierDetectionIntervalArgs>,
    public val maxEjectionPercent: Output<Int>,
    public val maxServerErrors: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerOutlierDetectionArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerOutlierDetectionArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerOutlierDetectionArgs.builder()
            .baseEjectionDuration(
                baseEjectionDuration.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .interval(interval.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .maxEjectionPercent(maxEjectionPercent.applyValue({ args0 -> args0 }))
            .maxServerErrors(maxServerErrors.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNodeSpecListenerOutlierDetectionArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecListenerOutlierDetectionArgsBuilder internal constructor() {
    private var baseEjectionDuration:
        Output<VirtualNodeSpecListenerOutlierDetectionBaseEjectionDurationArgs>? = null

    private var interval: Output<VirtualNodeSpecListenerOutlierDetectionIntervalArgs>? = null

    private var maxEjectionPercent: Output<Int>? = null

    private var maxServerErrors: Output<Int>? = null

    /**
     * @param value Base amount of time for which a host is ejected.
     */
    @JvmName("dingiuywnnfgnhfo")
    public suspend
    fun baseEjectionDuration(`value`: Output<VirtualNodeSpecListenerOutlierDetectionBaseEjectionDurationArgs>) {
        this.baseEjectionDuration = value
    }

    /**
     * @param value Time interval between ejection sweep analysis.
     */
    @JvmName("iwpjhtaoqxdqkblp")
    public suspend
    fun interval(`value`: Output<VirtualNodeSpecListenerOutlierDetectionIntervalArgs>) {
        this.interval = value
    }

    /**
     * @param value Maximum percentage of hosts in load balancing pool for upstream service that can be ejected. Will eject at least one host regardless of the value.
     * Minimum value of `0`. Maximum value of `100`.
     */
    @JvmName("erwqcxwkwwuskeib")
    public suspend fun maxEjectionPercent(`value`: Output<Int>) {
        this.maxEjectionPercent = value
    }

    /**
     * @param value Number of consecutive `5xx` errors required for ejection. Minimum value of `1`.
     */
    @JvmName("hyaobftgvgavyfpp")
    public suspend fun maxServerErrors(`value`: Output<Int>) {
        this.maxServerErrors = value
    }

    /**
     * @param value Base amount of time for which a host is ejected.
     */
    @JvmName("nedstyfecfirkjqg")
    public suspend
    fun baseEjectionDuration(`value`: VirtualNodeSpecListenerOutlierDetectionBaseEjectionDurationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.baseEjectionDuration = mapped
    }

    /**
     * @param argument Base amount of time for which a host is ejected.
     */
    @JvmName("hnqrfbcbcoxglcew")
    public suspend
    fun baseEjectionDuration(argument: suspend VirtualNodeSpecListenerOutlierDetectionBaseEjectionDurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualNodeSpecListenerOutlierDetectionBaseEjectionDurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.baseEjectionDuration = mapped
    }

    /**
     * @param value Time interval between ejection sweep analysis.
     */
    @JvmName("jlahsrjvwksqfgnq")
    public suspend fun interval(`value`: VirtualNodeSpecListenerOutlierDetectionIntervalArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param argument Time interval between ejection sweep analysis.
     */
    @JvmName("dugilfdbcgrpjpls")
    public suspend
    fun interval(argument: suspend VirtualNodeSpecListenerOutlierDetectionIntervalArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecListenerOutlierDetectionIntervalArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.interval = mapped
    }

    /**
     * @param value Maximum percentage of hosts in load balancing pool for upstream service that can be ejected. Will eject at least one host regardless of the value.
     * Minimum value of `0`. Maximum value of `100`.
     */
    @JvmName("uyyxbektqxjnecej")
    public suspend fun maxEjectionPercent(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxEjectionPercent = mapped
    }

    /**
     * @param value Number of consecutive `5xx` errors required for ejection. Minimum value of `1`.
     */
    @JvmName("ckuteycqfqsigqfs")
    public suspend fun maxServerErrors(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxServerErrors = mapped
    }

    internal fun build(): VirtualNodeSpecListenerOutlierDetectionArgs =
        VirtualNodeSpecListenerOutlierDetectionArgs(
            baseEjectionDuration = baseEjectionDuration ?: throw
                PulumiNullFieldException("baseEjectionDuration"),
            interval = interval ?: throw PulumiNullFieldException("interval"),
            maxEjectionPercent = maxEjectionPercent ?: throw PulumiNullFieldException("maxEjectionPercent"),
            maxServerErrors = maxServerErrors ?: throw PulumiNullFieldException("maxServerErrors"),
        )
}
