@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerPortMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property port Port used for the port mapping.
 * @property protocol Protocol used for the port mapping. Valid values are `http`, `http2`, `tcp` and `grpc`.
 */
public data class VirtualNodeSpecListenerPortMappingArgs(
    public val port: Output<Int>,
    public val protocol: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerPortMappingArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerPortMappingArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerPortMappingArgs.builder()
            .port(port.applyValue({ args0 -> args0 }))
            .protocol(protocol.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNodeSpecListenerPortMappingArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecListenerPortMappingArgsBuilder internal constructor() {
    private var port: Output<Int>? = null

    private var protocol: Output<String>? = null

    /**
     * @param value Port used for the port mapping.
     */
    @JvmName("nymwkkdfjwpodbbr")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Protocol used for the port mapping. Valid values are `http`, `http2`, `tcp` and `grpc`.
     */
    @JvmName("oqsnlyxfsreudjja")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value Port used for the port mapping.
     */
    @JvmName("kylmbxcmlqkdtsit")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Protocol used for the port mapping. Valid values are `http`, `http2`, `tcp` and `grpc`.
     */
    @JvmName("ymewnwxhgybdetff")
    public suspend fun protocol(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    internal fun build(): VirtualNodeSpecListenerPortMappingArgs =
        VirtualNodeSpecListenerPortMappingArgs(
            port = port ?: throw PulumiNullFieldException("port"),
            protocol = protocol ?: throw PulumiNullFieldException("protocol"),
        )
}
