@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTimeoutArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property grpc Timeouts for gRPC listeners.
 * @property http Timeouts for HTTP listeners.
 * @property http2 Timeouts for HTTP2 listeners.
 * @property tcp Timeouts for TCP listeners.
 */
public data class VirtualNodeSpecListenerTimeoutArgs(
    public val grpc: Output<VirtualNodeSpecListenerTimeoutGrpcArgs>? = null,
    public val http: Output<VirtualNodeSpecListenerTimeoutHttpArgs>? = null,
    public val http2: Output<VirtualNodeSpecListenerTimeoutHttp2Args>? = null,
    public val tcp: Output<VirtualNodeSpecListenerTimeoutTcpArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTimeoutArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTimeoutArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTimeoutArgs.builder()
            .grpc(grpc?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .http(http?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .http2(http2?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tcp(tcp?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualNodeSpecListenerTimeoutArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecListenerTimeoutArgsBuilder internal constructor() {
    private var grpc: Output<VirtualNodeSpecListenerTimeoutGrpcArgs>? = null

    private var http: Output<VirtualNodeSpecListenerTimeoutHttpArgs>? = null

    private var http2: Output<VirtualNodeSpecListenerTimeoutHttp2Args>? = null

    private var tcp: Output<VirtualNodeSpecListenerTimeoutTcpArgs>? = null

    /**
     * @param value Timeouts for gRPC listeners.
     */
    @JvmName("ibewumyynhddkshw")
    public suspend fun grpc(`value`: Output<VirtualNodeSpecListenerTimeoutGrpcArgs>) {
        this.grpc = value
    }

    /**
     * @param value Timeouts for HTTP listeners.
     */
    @JvmName("rqlgssdnbtqbqjub")
    public suspend fun http(`value`: Output<VirtualNodeSpecListenerTimeoutHttpArgs>) {
        this.http = value
    }

    /**
     * @param value Timeouts for HTTP2 listeners.
     */
    @JvmName("dgwwftgqruhkkdjb")
    public suspend fun http2(`value`: Output<VirtualNodeSpecListenerTimeoutHttp2Args>) {
        this.http2 = value
    }

    /**
     * @param value Timeouts for TCP listeners.
     */
    @JvmName("bovimibuqfslmbfr")
    public suspend fun tcp(`value`: Output<VirtualNodeSpecListenerTimeoutTcpArgs>) {
        this.tcp = value
    }

    /**
     * @param value Timeouts for gRPC listeners.
     */
    @JvmName("huiwibllcrgggihj")
    public suspend fun grpc(`value`: VirtualNodeSpecListenerTimeoutGrpcArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grpc = mapped
    }

    /**
     * @param argument Timeouts for gRPC listeners.
     */
    @JvmName("spqdbehxtoxttjer")
    public suspend
    fun grpc(argument: suspend VirtualNodeSpecListenerTimeoutGrpcArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecListenerTimeoutGrpcArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.grpc = mapped
    }

    /**
     * @param value Timeouts for HTTP listeners.
     */
    @JvmName("kyasshicaspnhpyg")
    public suspend fun http(`value`: VirtualNodeSpecListenerTimeoutHttpArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.http = mapped
    }

    /**
     * @param argument Timeouts for HTTP listeners.
     */
    @JvmName("gpwvlhkpglhxpvvd")
    public suspend
    fun http(argument: suspend VirtualNodeSpecListenerTimeoutHttpArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecListenerTimeoutHttpArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.http = mapped
    }

    /**
     * @param value Timeouts for HTTP2 listeners.
     */
    @JvmName("bmntqtomudtliuuy")
    public suspend fun http2(`value`: VirtualNodeSpecListenerTimeoutHttp2Args?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.http2 = mapped
    }

    /**
     * @param argument Timeouts for HTTP2 listeners.
     */
    @JvmName("rylqrxqoklreidvs")
    public suspend
    fun http2(argument: suspend VirtualNodeSpecListenerTimeoutHttp2ArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecListenerTimeoutHttp2ArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.http2 = mapped
    }

    /**
     * @param value Timeouts for TCP listeners.
     */
    @JvmName("htdgqbgkyixnhbsi")
    public suspend fun tcp(`value`: VirtualNodeSpecListenerTimeoutTcpArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tcp = mapped
    }

    /**
     * @param argument Timeouts for TCP listeners.
     */
    @JvmName("cwflxfppmbkqbeew")
    public suspend
    fun tcp(argument: suspend VirtualNodeSpecListenerTimeoutTcpArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecListenerTimeoutTcpArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.tcp = mapped
    }

    internal fun build(): VirtualNodeSpecListenerTimeoutArgs = VirtualNodeSpecListenerTimeoutArgs(
        grpc = grpc,
        http = http,
        http2 = http2,
        tcp = tcp,
    )
}
