@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTimeoutHttpArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property idle Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
 * @property perRequest Per request timeout.
 */
public data class VirtualNodeSpecListenerTimeoutHttpArgs(
    public val idle: Output<VirtualNodeSpecListenerTimeoutHttpIdleArgs>? = null,
    public val perRequest: Output<VirtualNodeSpecListenerTimeoutHttpPerRequestArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTimeoutHttpArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTimeoutHttpArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTimeoutHttpArgs.builder()
            .idle(idle?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .perRequest(perRequest?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualNodeSpecListenerTimeoutHttpArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecListenerTimeoutHttpArgsBuilder internal constructor() {
    private var idle: Output<VirtualNodeSpecListenerTimeoutHttpIdleArgs>? = null

    private var perRequest: Output<VirtualNodeSpecListenerTimeoutHttpPerRequestArgs>? = null

    /**
     * @param value Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
     */
    @JvmName("axpqmvqiylceqetn")
    public suspend fun idle(`value`: Output<VirtualNodeSpecListenerTimeoutHttpIdleArgs>) {
        this.idle = value
    }

    /**
     * @param value Per request timeout.
     */
    @JvmName("wdaibcnluosnnobv")
    public suspend fun perRequest(`value`: Output<VirtualNodeSpecListenerTimeoutHttpPerRequestArgs>) {
        this.perRequest = value
    }

    /**
     * @param value Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
     */
    @JvmName("pltklslfrvjiegtf")
    public suspend fun idle(`value`: VirtualNodeSpecListenerTimeoutHttpIdleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idle = mapped
    }

    /**
     * @param argument Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
     */
    @JvmName("usgngcyndgsbdqmm")
    public suspend
    fun idle(argument: suspend VirtualNodeSpecListenerTimeoutHttpIdleArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecListenerTimeoutHttpIdleArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.idle = mapped
    }

    /**
     * @param value Per request timeout.
     */
    @JvmName("nwwskxiamhdseoam")
    public suspend fun perRequest(`value`: VirtualNodeSpecListenerTimeoutHttpPerRequestArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.perRequest = mapped
    }

    /**
     * @param argument Per request timeout.
     */
    @JvmName("jyqjjgnuwynydarf")
    public suspend
    fun perRequest(argument: suspend VirtualNodeSpecListenerTimeoutHttpPerRequestArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecListenerTimeoutHttpPerRequestArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.perRequest = mapped
    }

    internal fun build(): VirtualNodeSpecListenerTimeoutHttpArgs =
        VirtualNodeSpecListenerTimeoutHttpArgs(
            idle = idle,
            perRequest = perRequest,
        )
}
