@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTimeoutTcpArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property idle Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
 */
public data class VirtualNodeSpecListenerTimeoutTcpArgs(
    public val idle: Output<VirtualNodeSpecListenerTimeoutTcpIdleArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTimeoutTcpArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTimeoutTcpArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTimeoutTcpArgs.builder()
            .idle(idle?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualNodeSpecListenerTimeoutTcpArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecListenerTimeoutTcpArgsBuilder internal constructor() {
    private var idle: Output<VirtualNodeSpecListenerTimeoutTcpIdleArgs>? = null

    /**
     * @param value Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
     */
    @JvmName("qimyplydekwouedd")
    public suspend fun idle(`value`: Output<VirtualNodeSpecListenerTimeoutTcpIdleArgs>) {
        this.idle = value
    }

    /**
     * @param value Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
     */
    @JvmName("lcovylglftdrgdfv")
    public suspend fun idle(`value`: VirtualNodeSpecListenerTimeoutTcpIdleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idle = mapped
    }

    /**
     * @param argument Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
     */
    @JvmName("wdmpoyemxxoibijt")
    public suspend
    fun idle(argument: suspend VirtualNodeSpecListenerTimeoutTcpIdleArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecListenerTimeoutTcpIdleArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.idle = mapped
    }

    internal fun build(): VirtualNodeSpecListenerTimeoutTcpArgs =
        VirtualNodeSpecListenerTimeoutTcpArgs(
            idle = idle,
        )
}
