@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTlsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property certificate Listener's TLS certificate.
 * @property mode Listener's TLS mode. Valid values: `DISABLED`, `PERMISSIVE`, `STRICT`.
 * @property validation Listener's Transport Layer Security (TLS) validation context.
 */
public data class VirtualNodeSpecListenerTlsArgs(
    public val certificate: Output<VirtualNodeSpecListenerTlsCertificateArgs>,
    public val mode: Output<String>,
    public val validation: Output<VirtualNodeSpecListenerTlsValidationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTlsArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTlsArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTlsArgs.builder()
            .certificate(certificate.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .mode(mode.applyValue({ args0 -> args0 }))
            .validation(validation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualNodeSpecListenerTlsArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecListenerTlsArgsBuilder internal constructor() {
    private var certificate: Output<VirtualNodeSpecListenerTlsCertificateArgs>? = null

    private var mode: Output<String>? = null

    private var validation: Output<VirtualNodeSpecListenerTlsValidationArgs>? = null

    /**
     * @param value Listener's TLS certificate.
     */
    @JvmName("pwdysfjmcaqgntcf")
    public suspend fun certificate(`value`: Output<VirtualNodeSpecListenerTlsCertificateArgs>) {
        this.certificate = value
    }

    /**
     * @param value Listener's TLS mode. Valid values: `DISABLED`, `PERMISSIVE`, `STRICT`.
     */
    @JvmName("yjptkxrwypqbwewk")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value Listener's Transport Layer Security (TLS) validation context.
     */
    @JvmName("tniclmxcedfgxpof")
    public suspend fun validation(`value`: Output<VirtualNodeSpecListenerTlsValidationArgs>) {
        this.validation = value
    }

    /**
     * @param value Listener's TLS certificate.
     */
    @JvmName("lhamaqyklfpwoblh")
    public suspend fun certificate(`value`: VirtualNodeSpecListenerTlsCertificateArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificate = mapped
    }

    /**
     * @param argument Listener's TLS certificate.
     */
    @JvmName("qbgqfmcfxpqqgmwk")
    public suspend
    fun certificate(argument: suspend VirtualNodeSpecListenerTlsCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecListenerTlsCertificateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.certificate = mapped
    }

    /**
     * @param value Listener's TLS mode. Valid values: `DISABLED`, `PERMISSIVE`, `STRICT`.
     */
    @JvmName("gqncbpsnquernvoo")
    public suspend fun mode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Listener's Transport Layer Security (TLS) validation context.
     */
    @JvmName("pxmgmpadsudqjxsa")
    public suspend fun validation(`value`: VirtualNodeSpecListenerTlsValidationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validation = mapped
    }

    /**
     * @param argument Listener's Transport Layer Security (TLS) validation context.
     */
    @JvmName("eynxishgdfprifjf")
    public suspend
    fun validation(argument: suspend VirtualNodeSpecListenerTlsValidationArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecListenerTlsValidationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.validation = mapped
    }

    internal fun build(): VirtualNodeSpecListenerTlsArgs = VirtualNodeSpecListenerTlsArgs(
        certificate = certificate ?: throw PulumiNullFieldException("certificate"),
        mode = mode ?: throw PulumiNullFieldException("mode"),
        validation = validation,
    )
}
