@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTlsCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property acm An AWS Certificate Manager (ACM) certificate.
 * @property file Local file certificate.
 * @property sds A [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
 */
public data class VirtualNodeSpecListenerTlsCertificateArgs(
    public val acm: Output<VirtualNodeSpecListenerTlsCertificateAcmArgs>? = null,
    public val `file`: Output<VirtualNodeSpecListenerTlsCertificateFileArgs>? = null,
    public val sds: Output<VirtualNodeSpecListenerTlsCertificateSdsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTlsCertificateArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTlsCertificateArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTlsCertificateArgs.builder()
            .acm(acm?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .`file`(`file`?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sds(sds?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualNodeSpecListenerTlsCertificateArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecListenerTlsCertificateArgsBuilder internal constructor() {
    private var acm: Output<VirtualNodeSpecListenerTlsCertificateAcmArgs>? = null

    private var `file`: Output<VirtualNodeSpecListenerTlsCertificateFileArgs>? = null

    private var sds: Output<VirtualNodeSpecListenerTlsCertificateSdsArgs>? = null

    /**
     * @param value An AWS Certificate Manager (ACM) certificate.
     */
    @JvmName("fsmcteshvxwyhrtj")
    public suspend fun acm(`value`: Output<VirtualNodeSpecListenerTlsCertificateAcmArgs>) {
        this.acm = value
    }

    /**
     * @param value Local file certificate.
     */
    @JvmName("dkugfrmuuttlmjyj")
    public suspend fun `file`(`value`: Output<VirtualNodeSpecListenerTlsCertificateFileArgs>) {
        this.`file` = value
    }

    /**
     * @param value A [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
     */
    @JvmName("wbfebdjdxcicaclp")
    public suspend fun sds(`value`: Output<VirtualNodeSpecListenerTlsCertificateSdsArgs>) {
        this.sds = value
    }

    /**
     * @param value An AWS Certificate Manager (ACM) certificate.
     */
    @JvmName("xumbrvdigmxqajkb")
    public suspend fun acm(`value`: VirtualNodeSpecListenerTlsCertificateAcmArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acm = mapped
    }

    /**
     * @param argument An AWS Certificate Manager (ACM) certificate.
     */
    @JvmName("usujxbhgwjsbnuho")
    public suspend
    fun acm(argument: suspend VirtualNodeSpecListenerTlsCertificateAcmArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecListenerTlsCertificateAcmArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.acm = mapped
    }

    /**
     * @param value Local file certificate.
     */
    @JvmName("mghwocjllucpogqk")
    public suspend fun `file`(`value`: VirtualNodeSpecListenerTlsCertificateFileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`file` = mapped
    }

    /**
     * @param argument Local file certificate.
     */
    @JvmName("xpkivjknekenqnfi")
    public suspend
    fun `file`(argument: suspend VirtualNodeSpecListenerTlsCertificateFileArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecListenerTlsCertificateFileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.`file` = mapped
    }

    /**
     * @param value A [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
     */
    @JvmName("liscotnnhqbxbqfj")
    public suspend fun sds(`value`: VirtualNodeSpecListenerTlsCertificateSdsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sds = mapped
    }

    /**
     * @param argument A [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
     */
    @JvmName("ybhdebyibbsoombj")
    public suspend
    fun sds(argument: suspend VirtualNodeSpecListenerTlsCertificateSdsArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecListenerTlsCertificateSdsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sds = mapped
    }

    internal fun build(): VirtualNodeSpecListenerTlsCertificateArgs =
        VirtualNodeSpecListenerTlsCertificateArgs(
            acm = acm,
            `file` = `file`,
            sds = sds,
        )
}
