@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTlsValidationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property subjectAlternativeNames SANs for a TLS validation context.
 * @property trust TLS validation context trust.
 */
public data class VirtualNodeSpecListenerTlsValidationArgs(
    public val subjectAlternativeNames:
    Output<VirtualNodeSpecListenerTlsValidationSubjectAlternativeNamesArgs>? = null,
    public val trust: Output<VirtualNodeSpecListenerTlsValidationTrustArgs>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTlsValidationArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTlsValidationArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTlsValidationArgs.builder()
            .subjectAlternativeNames(
                subjectAlternativeNames?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .trust(trust.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualNodeSpecListenerTlsValidationArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecListenerTlsValidationArgsBuilder internal constructor() {
    private var subjectAlternativeNames:
        Output<VirtualNodeSpecListenerTlsValidationSubjectAlternativeNamesArgs>? = null

    private var trust: Output<VirtualNodeSpecListenerTlsValidationTrustArgs>? = null

    /**
     * @param value SANs for a TLS validation context.
     */
    @JvmName("idlvqjecqlwsmdxt")
    public suspend
    fun subjectAlternativeNames(`value`: Output<VirtualNodeSpecListenerTlsValidationSubjectAlternativeNamesArgs>) {
        this.subjectAlternativeNames = value
    }

    /**
     * @param value TLS validation context trust.
     */
    @JvmName("fdypfchwdatnirvi")
    public suspend fun trust(`value`: Output<VirtualNodeSpecListenerTlsValidationTrustArgs>) {
        this.trust = value
    }

    /**
     * @param value SANs for a TLS validation context.
     */
    @JvmName("kutulwsolnxhnbfw")
    public suspend
    fun subjectAlternativeNames(`value`: VirtualNodeSpecListenerTlsValidationSubjectAlternativeNamesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subjectAlternativeNames = mapped
    }

    /**
     * @param argument SANs for a TLS validation context.
     */
    @JvmName("esysddcidvnicfyx")
    public suspend
    fun subjectAlternativeNames(argument: suspend VirtualNodeSpecListenerTlsValidationSubjectAlternativeNamesArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualNodeSpecListenerTlsValidationSubjectAlternativeNamesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.subjectAlternativeNames = mapped
    }

    /**
     * @param value TLS validation context trust.
     */
    @JvmName("xwstwflmknwbkyfc")
    public suspend fun trust(`value`: VirtualNodeSpecListenerTlsValidationTrustArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trust = mapped
    }

    /**
     * @param argument TLS validation context trust.
     */
    @JvmName("tnhnldvvfhkavapf")
    public suspend
    fun trust(argument: suspend VirtualNodeSpecListenerTlsValidationTrustArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecListenerTlsValidationTrustArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.trust = mapped
    }

    internal fun build(): VirtualNodeSpecListenerTlsValidationArgs =
        VirtualNodeSpecListenerTlsValidationArgs(
            subjectAlternativeNames = subjectAlternativeNames,
            trust = trust ?: throw PulumiNullFieldException("trust"),
        )
}
