@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecLoggingAccessLogArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property file File object to send virtual node access logs to.
 */
public data class VirtualNodeSpecLoggingAccessLogArgs(
    public val `file`: Output<VirtualNodeSpecLoggingAccessLogFileArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecLoggingAccessLogArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecLoggingAccessLogArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecLoggingAccessLogArgs.builder()
            .`file`(`file`?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualNodeSpecLoggingAccessLogArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecLoggingAccessLogArgsBuilder internal constructor() {
    private var `file`: Output<VirtualNodeSpecLoggingAccessLogFileArgs>? = null

    /**
     * @param value File object to send virtual node access logs to.
     */
    @JvmName("oddlshnbqxbeqydg")
    public suspend fun `file`(`value`: Output<VirtualNodeSpecLoggingAccessLogFileArgs>) {
        this.`file` = value
    }

    /**
     * @param value File object to send virtual node access logs to.
     */
    @JvmName("jmtfndxnjrjytlem")
    public suspend fun `file`(`value`: VirtualNodeSpecLoggingAccessLogFileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`file` = mapped
    }

    /**
     * @param argument File object to send virtual node access logs to.
     */
    @JvmName("hvfccuhulcipehxy")
    public suspend
    fun `file`(argument: suspend VirtualNodeSpecLoggingAccessLogFileArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecLoggingAccessLogFileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.`file` = mapped
    }

    internal fun build(): VirtualNodeSpecLoggingAccessLogArgs = VirtualNodeSpecLoggingAccessLogArgs(
        `file` = `file`,
    )
}
