@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecLoggingAccessLogFileFormatJsonArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key The specified key for the JSON. Must be between 1 and 100 characters in length.
 * @property value The specified value for the JSON. Must be between 1 and 100 characters in length.
 */
public data class VirtualNodeSpecLoggingAccessLogFileFormatJsonArgs(
    public val key: Output<String>,
    public val `value`: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecLoggingAccessLogFileFormatJsonArgs> {
    override fun toJava():
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecLoggingAccessLogFileFormatJsonArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecLoggingAccessLogFileFormatJsonArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNodeSpecLoggingAccessLogFileFormatJsonArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecLoggingAccessLogFileFormatJsonArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The specified key for the JSON. Must be between 1 and 100 characters in length.
     */
    @JvmName("hnkmxiduhcxwqvow")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The specified value for the JSON. Must be between 1 and 100 characters in length.
     */
    @JvmName("inrfvijuitkipdur")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The specified key for the JSON. Must be between 1 and 100 characters in length.
     */
    @JvmName("qorcxidujaoichbv")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The specified value for the JSON. Must be between 1 and 100 characters in length.
     */
    @JvmName("sucitpgorrdjlrme")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): VirtualNodeSpecLoggingAccessLogFileFormatJsonArgs =
        VirtualNodeSpecLoggingAccessLogFileFormatJsonArgs(
            key = key ?: throw PulumiNullFieldException("key"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
