@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecLoggingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property accessLog Access log configuration for a virtual node.
 */
public data class VirtualNodeSpecLoggingArgs(
    public val accessLog: Output<VirtualNodeSpecLoggingAccessLogArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecLoggingArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecLoggingArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecLoggingArgs.builder()
            .accessLog(accessLog?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualNodeSpecLoggingArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecLoggingArgsBuilder internal constructor() {
    private var accessLog: Output<VirtualNodeSpecLoggingAccessLogArgs>? = null

    /**
     * @param value Access log configuration for a virtual node.
     */
    @JvmName("eblbafwnosadmege")
    public suspend fun accessLog(`value`: Output<VirtualNodeSpecLoggingAccessLogArgs>) {
        this.accessLog = value
    }

    /**
     * @param value Access log configuration for a virtual node.
     */
    @JvmName("wxkrjytthtctylpw")
    public suspend fun accessLog(`value`: VirtualNodeSpecLoggingAccessLogArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessLog = mapped
    }

    /**
     * @param argument Access log configuration for a virtual node.
     */
    @JvmName("gqdpxkuvwyxxvsre")
    public suspend
    fun accessLog(argument: suspend VirtualNodeSpecLoggingAccessLogArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecLoggingAccessLogArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accessLog = mapped
    }

    internal fun build(): VirtualNodeSpecLoggingArgs = VirtualNodeSpecLoggingArgs(
        accessLog = accessLog,
    )
}
