@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecServiceDiscoveryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property awsCloudMap Any AWS Cloud Map information for the virtual node.
 * @property dns DNS service name for the virtual node.
 */
public data class VirtualNodeSpecServiceDiscoveryArgs(
    public val awsCloudMap: Output<VirtualNodeSpecServiceDiscoveryAwsCloudMapArgs>? = null,
    public val dns: Output<VirtualNodeSpecServiceDiscoveryDnsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecServiceDiscoveryArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecServiceDiscoveryArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecServiceDiscoveryArgs.builder()
            .awsCloudMap(awsCloudMap?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dns(dns?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualNodeSpecServiceDiscoveryArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecServiceDiscoveryArgsBuilder internal constructor() {
    private var awsCloudMap: Output<VirtualNodeSpecServiceDiscoveryAwsCloudMapArgs>? = null

    private var dns: Output<VirtualNodeSpecServiceDiscoveryDnsArgs>? = null

    /**
     * @param value Any AWS Cloud Map information for the virtual node.
     */
    @JvmName("ydvhrrgedlwrhjbk")
    public suspend fun awsCloudMap(`value`: Output<VirtualNodeSpecServiceDiscoveryAwsCloudMapArgs>) {
        this.awsCloudMap = value
    }

    /**
     * @param value DNS service name for the virtual node.
     */
    @JvmName("vqvmnelfarxexofm")
    public suspend fun dns(`value`: Output<VirtualNodeSpecServiceDiscoveryDnsArgs>) {
        this.dns = value
    }

    /**
     * @param value Any AWS Cloud Map information for the virtual node.
     */
    @JvmName("omievrvmhofelpja")
    public suspend fun awsCloudMap(`value`: VirtualNodeSpecServiceDiscoveryAwsCloudMapArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsCloudMap = mapped
    }

    /**
     * @param argument Any AWS Cloud Map information for the virtual node.
     */
    @JvmName("vfhqgpltchvngtex")
    public suspend
    fun awsCloudMap(argument: suspend VirtualNodeSpecServiceDiscoveryAwsCloudMapArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecServiceDiscoveryAwsCloudMapArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.awsCloudMap = mapped
    }

    /**
     * @param value DNS service name for the virtual node.
     */
    @JvmName("edvukgumerjljnvy")
    public suspend fun dns(`value`: VirtualNodeSpecServiceDiscoveryDnsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dns = mapped
    }

    /**
     * @param argument DNS service name for the virtual node.
     */
    @JvmName("iaywtxgjcengqggo")
    public suspend
    fun dns(argument: suspend VirtualNodeSpecServiceDiscoveryDnsArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecServiceDiscoveryDnsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dns = mapped
    }

    internal fun build(): VirtualNodeSpecServiceDiscoveryArgs = VirtualNodeSpecServiceDiscoveryArgs(
        awsCloudMap = awsCloudMap,
        dns = dns,
    )
}
