@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecServiceDiscoveryDnsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hostname DNS host name for your virtual node.
 * @property ipPreference The preferred IP version that this virtual node uses. Valid values: `IPv6_PREFERRED`, `IPv4_PREFERRED`, `IPv4_ONLY`, `IPv6_ONLY`.
 * @property responseType The DNS response type for the virtual node. Valid values: `LOADBALANCER`, `ENDPOINTS`.
 */
public data class VirtualNodeSpecServiceDiscoveryDnsArgs(
    public val hostname: Output<String>,
    public val ipPreference: Output<String>? = null,
    public val responseType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecServiceDiscoveryDnsArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecServiceDiscoveryDnsArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecServiceDiscoveryDnsArgs.builder()
            .hostname(hostname.applyValue({ args0 -> args0 }))
            .ipPreference(ipPreference?.applyValue({ args0 -> args0 }))
            .responseType(responseType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNodeSpecServiceDiscoveryDnsArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecServiceDiscoveryDnsArgsBuilder internal constructor() {
    private var hostname: Output<String>? = null

    private var ipPreference: Output<String>? = null

    private var responseType: Output<String>? = null

    /**
     * @param value DNS host name for your virtual node.
     */
    @JvmName("ygxojxjvhfpadwqp")
    public suspend fun hostname(`value`: Output<String>) {
        this.hostname = value
    }

    /**
     * @param value The preferred IP version that this virtual node uses. Valid values: `IPv6_PREFERRED`, `IPv4_PREFERRED`, `IPv4_ONLY`, `IPv6_ONLY`.
     */
    @JvmName("aecalfqvyxqntylp")
    public suspend fun ipPreference(`value`: Output<String>) {
        this.ipPreference = value
    }

    /**
     * @param value The DNS response type for the virtual node. Valid values: `LOADBALANCER`, `ENDPOINTS`.
     */
    @JvmName("omldhvgxjvsfdmwf")
    public suspend fun responseType(`value`: Output<String>) {
        this.responseType = value
    }

    /**
     * @param value DNS host name for your virtual node.
     */
    @JvmName("xbvmerbjytkjvesy")
    public suspend fun hostname(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostname = mapped
    }

    /**
     * @param value The preferred IP version that this virtual node uses. Valid values: `IPv6_PREFERRED`, `IPv4_PREFERRED`, `IPv4_ONLY`, `IPv6_ONLY`.
     */
    @JvmName("eudipohnfnttjbtm")
    public suspend fun ipPreference(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipPreference = mapped
    }

    /**
     * @param value The DNS response type for the virtual node. Valid values: `LOADBALANCER`, `ENDPOINTS`.
     */
    @JvmName("nlbltemexcdyagip")
    public suspend fun responseType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseType = mapped
    }

    internal fun build(): VirtualNodeSpecServiceDiscoveryDnsArgs =
        VirtualNodeSpecServiceDiscoveryDnsArgs(
            hostname = hostname ?: throw PulumiNullFieldException("hostname"),
            ipPreference = ipPreference,
            responseType = responseType,
        )
}
