@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualRouterSpecListenerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property portMapping Port mapping information for the listener.
 */
public data class VirtualRouterSpecListenerArgs(
    public val portMapping: Output<VirtualRouterSpecListenerPortMappingArgs>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualRouterSpecListenerArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualRouterSpecListenerArgs =
        com.pulumi.aws.appmesh.inputs.VirtualRouterSpecListenerArgs.builder()
            .portMapping(portMapping.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualRouterSpecListenerArgs].
 */
@PulumiTagMarker
public class VirtualRouterSpecListenerArgsBuilder internal constructor() {
    private var portMapping: Output<VirtualRouterSpecListenerPortMappingArgs>? = null

    /**
     * @param value Port mapping information for the listener.
     */
    @JvmName("jdlhnapteojuddky")
    public suspend fun portMapping(`value`: Output<VirtualRouterSpecListenerPortMappingArgs>) {
        this.portMapping = value
    }

    /**
     * @param value Port mapping information for the listener.
     */
    @JvmName("dschscddwuxfiouh")
    public suspend fun portMapping(`value`: VirtualRouterSpecListenerPortMappingArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.portMapping = mapped
    }

    /**
     * @param argument Port mapping information for the listener.
     */
    @JvmName("vfnxxoksenryvwyv")
    public suspend
    fun portMapping(argument: suspend VirtualRouterSpecListenerPortMappingArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualRouterSpecListenerPortMappingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.portMapping = mapped
    }

    internal fun build(): VirtualRouterSpecListenerArgs = VirtualRouterSpecListenerArgs(
        portMapping = portMapping ?: throw PulumiNullFieldException("portMapping"),
    )
}
