@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualServiceSpecArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property provider App Mesh object that is acting as the provider for a virtual service. You can specify a single virtual node or virtual router.
 */
public data class VirtualServiceSpecArgs(
    public val provider: Output<VirtualServiceSpecProviderArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualServiceSpecArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualServiceSpecArgs =
        com.pulumi.aws.appmesh.inputs.VirtualServiceSpecArgs.builder()
            .provider(provider?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualServiceSpecArgs].
 */
@PulumiTagMarker
public class VirtualServiceSpecArgsBuilder internal constructor() {
    private var provider: Output<VirtualServiceSpecProviderArgs>? = null

    /**
     * @param value App Mesh object that is acting as the provider for a virtual service. You can specify a single virtual node or virtual router.
     */
    @JvmName("rvnuavajvaxrkanv")
    public suspend fun provider(`value`: Output<VirtualServiceSpecProviderArgs>) {
        this.provider = value
    }

    /**
     * @param value App Mesh object that is acting as the provider for a virtual service. You can specify a single virtual node or virtual router.
     */
    @JvmName("xdcoqxiehvnwcqol")
    public suspend fun provider(`value`: VirtualServiceSpecProviderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provider = mapped
    }

    /**
     * @param argument App Mesh object that is acting as the provider for a virtual service. You can specify a single virtual node or virtual router.
     */
    @JvmName("nrnxytmfuucarlio")
    public suspend fun provider(argument: suspend VirtualServiceSpecProviderArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualServiceSpecProviderArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.provider = mapped
    }

    internal fun build(): VirtualServiceSpecArgs = VirtualServiceSpecArgs(
        provider = provider,
    )
}
