@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualServiceSpecProviderVirtualNodeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property virtualNodeName Name of the virtual node that is acting as a service provider. Must be between 1 and 255 characters in length.
 */
public data class VirtualServiceSpecProviderVirtualNodeArgs(
    public val virtualNodeName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualServiceSpecProviderVirtualNodeArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualServiceSpecProviderVirtualNodeArgs =
        com.pulumi.aws.appmesh.inputs.VirtualServiceSpecProviderVirtualNodeArgs.builder()
            .virtualNodeName(virtualNodeName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualServiceSpecProviderVirtualNodeArgs].
 */
@PulumiTagMarker
public class VirtualServiceSpecProviderVirtualNodeArgsBuilder internal constructor() {
    private var virtualNodeName: Output<String>? = null

    /**
     * @param value Name of the virtual node that is acting as a service provider. Must be between 1 and 255 characters in length.
     */
    @JvmName("acynofjivybbsyfo")
    public suspend fun virtualNodeName(`value`: Output<String>) {
        this.virtualNodeName = value
    }

    /**
     * @param value Name of the virtual node that is acting as a service provider. Must be between 1 and 255 characters in length.
     */
    @JvmName("yqikjxcapvonbnej")
    public suspend fun virtualNodeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualNodeName = mapped
    }

    internal fun build(): VirtualServiceSpecProviderVirtualNodeArgs =
        VirtualServiceSpecProviderVirtualNodeArgs(
            virtualNodeName = virtualNodeName ?: throw PulumiNullFieldException("virtualNodeName"),
        )
}
