@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualServiceSpecProviderVirtualRouterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property virtualRouterName Name of the virtual router that is acting as a service provider. Must be between 1 and 255 characters in length.
 */
public data class VirtualServiceSpecProviderVirtualRouterArgs(
    public val virtualRouterName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualServiceSpecProviderVirtualRouterArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualServiceSpecProviderVirtualRouterArgs =
        com.pulumi.aws.appmesh.inputs.VirtualServiceSpecProviderVirtualRouterArgs.builder()
            .virtualRouterName(virtualRouterName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualServiceSpecProviderVirtualRouterArgs].
 */
@PulumiTagMarker
public class VirtualServiceSpecProviderVirtualRouterArgsBuilder internal constructor() {
    private var virtualRouterName: Output<String>? = null

    /**
     * @param value Name of the virtual router that is acting as a service provider. Must be between 1 and 255 characters in length.
     */
    @JvmName("gebudsylpgventqe")
    public suspend fun virtualRouterName(`value`: Output<String>) {
        this.virtualRouterName = value
    }

    /**
     * @param value Name of the virtual router that is acting as a service provider. Must be between 1 and 255 characters in length.
     */
    @JvmName("uobsaytnppflvrkj")
    public suspend fun virtualRouterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualRouterName = mapped
    }

    internal fun build(): VirtualServiceSpecProviderVirtualRouterArgs =
        VirtualServiceSpecProviderVirtualRouterArgs(
            virtualRouterName = virtualRouterName ?: throw PulumiNullFieldException("virtualRouterName"),
        )
}
