@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property grpcRoute Specification of a gRPC gateway route.
 * @property http2Route Specification of an HTTP/2 gateway route.
 * @property httpRoute Specification of an HTTP gateway route.
 * @property priority Priority for the gateway route, between `0` and `1000`.
 */
public data class GatewayRouteSpec(
    public val grpcRoute: GatewayRouteSpecGrpcRoute? = null,
    public val http2Route: GatewayRouteSpecHttp2Route? = null,
    public val httpRoute: GatewayRouteSpecHttpRoute? = null,
    public val priority: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.GatewayRouteSpec): GatewayRouteSpec =
            GatewayRouteSpec(
                grpcRoute = javaType.grpcRoute().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appmesh.kotlin.outputs.GatewayRouteSpecGrpcRoute.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                http2Route = javaType.http2Route().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appmesh.kotlin.outputs.GatewayRouteSpecHttp2Route.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                httpRoute = javaType.httpRoute().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appmesh.kotlin.outputs.GatewayRouteSpecHttpRoute.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            )
    }
}
