@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property port The port number to match from the request.
 * @property serviceName Fully qualified domain name for the service to match from the request.
 */
public data class GatewayRouteSpecGrpcRouteMatch(
    public val port: Int? = null,
    public val serviceName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.GatewayRouteSpecGrpcRouteMatch):
            GatewayRouteSpecGrpcRouteMatch = GatewayRouteSpecGrpcRouteMatch(
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            serviceName = javaType.serviceName(),
        )
    }
}
