@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property port The port number that corresponds to the target for Virtual Service provider port. This is required when the provider (router or node) of the Virtual Service has multiple listeners.
 * @property virtualService Virtual service gateway route target.
 */
public data class GatewayRouteSpecHttp2RouteActionTarget(
    public val port: Int? = null,
    public val virtualService: GatewayRouteSpecHttp2RouteActionTargetVirtualService,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.GatewayRouteSpecHttp2RouteActionTarget):
            GatewayRouteSpecHttp2RouteActionTarget = GatewayRouteSpecHttp2RouteActionTarget(
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            virtualService = javaType.virtualService().let({ args0 ->
                com.pulumi.aws.appmesh.kotlin.outputs.GatewayRouteSpecHttp2RouteActionTargetVirtualService.Companion.toKotlin(args0)
            }),
        )
    }
}
