@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property headers Client request headers to match on.
 * @property hostname Host name to match on.
 * @property path Client request path to match on.
 * @property port The port number to match from the request.
 * @property prefix Header value sent by the client must begin with the specified characters.
 * @property queryParameters Client request query parameters to match on.
 */
public data class GatewayRouteSpecHttp2RouteMatch(
    public val headers: List<GatewayRouteSpecHttp2RouteMatchHeader>? = null,
    public val hostname: GatewayRouteSpecHttp2RouteMatchHostname? = null,
    public val path: GatewayRouteSpecHttp2RouteMatchPath? = null,
    public val port: Int? = null,
    public val prefix: String? = null,
    public val queryParameters: List<GatewayRouteSpecHttp2RouteMatchQueryParameter>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.GatewayRouteSpecHttp2RouteMatch):
            GatewayRouteSpecHttp2RouteMatch = GatewayRouteSpecHttp2RouteMatch(
            headers = javaType.headers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GatewayRouteSpecHttp2RouteMatchHeader.Companion.toKotlin(args0)
                })
            }),
            hostname = javaType.hostname().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GatewayRouteSpecHttp2RouteMatchHostname.Companion.toKotlin(args0)
                })
            }).orElse(null),
            path = javaType.path().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GatewayRouteSpecHttp2RouteMatchPath.Companion.toKotlin(args0)
                })
            }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
            queryParameters = javaType.queryParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GatewayRouteSpecHttp2RouteMatchQueryParameter.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
