@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property invert If `true`, the match is on the opposite of the `match` method and value. Default is `false`.
 * @property match Method and value to match the header value sent with a request. Specify one match method.
 * @property name Name for the HTTP header in the client request that will be matched on.
 */
public data class GatewayRouteSpecHttp2RouteMatchHeader(
    public val invert: Boolean? = null,
    public val match: GatewayRouteSpecHttp2RouteMatchHeaderMatch? = null,
    public val name: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.GatewayRouteSpecHttp2RouteMatchHeader):
            GatewayRouteSpecHttp2RouteMatchHeader = GatewayRouteSpecHttp2RouteMatchHeader(
            invert = javaType.invert().map({ args0 -> args0 }).orElse(null),
            match = javaType.match().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GatewayRouteSpecHttp2RouteMatchHeaderMatch.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
        )
    }
}
