@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getMesh.
 * @property arn ARN of the service mesh.
 * @property createdDate Creation date of the service mesh.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property lastUpdatedDate Last update date of the service mesh.
 * @property meshOwner
 * @property name
 * @property resourceOwner Resource owner's AWS account ID.
 * @property specs Service mesh specification. See the `aws.appmesh.Mesh` resource for details.
 * @property tags Map of tags.
 */
public data class GetMeshResult(
    public val arn: String,
    public val createdDate: String,
    public val id: String,
    public val lastUpdatedDate: String,
    public val meshOwner: String,
    public val name: String,
    public val resourceOwner: String,
    public val specs: List<GetMeshSpec>,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.GetMeshResult): GetMeshResult =
            GetMeshResult(
                arn = javaType.arn(),
                createdDate = javaType.createdDate(),
                id = javaType.id(),
                lastUpdatedDate = javaType.lastUpdatedDate(),
                meshOwner = javaType.meshOwner(),
                name = javaType.name(),
                resourceOwner = javaType.resourceOwner(),
                specs = javaType.specs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appmesh.kotlin.outputs.GetMeshSpec.Companion.toKotlin(args0)
                    })
                }),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
