@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getRoute.
 * @property arn ARN of the route.
 * @property createdDate Creation date of the route.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property lastUpdatedDate Last update date of the route.
 * @property meshName
 * @property meshOwner
 * @property name
 * @property resourceOwner Resource owner's AWS account ID.
 * @property specs Route specification. See the `aws.appmesh.Route` resource for details.
 * @property tags Map of tags.
 * @property virtualRouterName
 */
public data class GetRouteResult(
    public val arn: String,
    public val createdDate: String,
    public val id: String,
    public val lastUpdatedDate: String,
    public val meshName: String,
    public val meshOwner: String,
    public val name: String,
    public val resourceOwner: String,
    public val specs: List<GetRouteSpec>,
    public val tags: Map<String, String>,
    public val virtualRouterName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.GetRouteResult): GetRouteResult =
            GetRouteResult(
                arn = javaType.arn(),
                createdDate = javaType.createdDate(),
                id = javaType.id(),
                lastUpdatedDate = javaType.lastUpdatedDate(),
                meshName = javaType.meshName(),
                meshOwner = javaType.meshOwner(),
                name = javaType.name(),
                resourceOwner = javaType.resourceOwner(),
                specs = javaType.specs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appmesh.kotlin.outputs.GetRouteSpec.Companion.toKotlin(args0)
                    })
                }),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                virtualRouterName = javaType.virtualRouterName(),
            )
    }
}
