@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property httpRetryEvents
 * @property maxRetries
 * @property perRetryTimeouts
 * @property tcpRetryEvents
 */
public data class GetRouteSpecHttpRouteRetryPolicy(
    public val httpRetryEvents: List<String>,
    public val maxRetries: Int,
    public val perRetryTimeouts: List<GetRouteSpecHttpRouteRetryPolicyPerRetryTimeout>,
    public val tcpRetryEvents: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.GetRouteSpecHttpRouteRetryPolicy):
            GetRouteSpecHttpRouteRetryPolicy = GetRouteSpecHttpRouteRetryPolicy(
            httpRetryEvents = javaType.httpRetryEvents().map({ args0 -> args0 }),
            maxRetries = javaType.maxRetries(),
            perRetryTimeouts = javaType.perRetryTimeouts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetRouteSpecHttpRouteRetryPolicyPerRetryTimeout.Companion.toKotlin(args0)
                })
            }),
            tcpRetryEvents = javaType.tcpRetryEvents().map({ args0 -> args0 }),
        )
    }
}
