@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property backendDefaults
 * @property listeners
 * @property loggings
 */
public data class GetVirtualGatewaySpec(
    public val backendDefaults: List<GetVirtualGatewaySpecBackendDefault>,
    public val listeners: List<GetVirtualGatewaySpecListener>,
    public val loggings: List<GetVirtualGatewaySpecLogging>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.GetVirtualGatewaySpec):
            GetVirtualGatewaySpec = GetVirtualGatewaySpec(
            backendDefaults = javaType.backendDefaults().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualGatewaySpecBackendDefault.Companion.toKotlin(args0)
                })
            }),
            listeners = javaType.listeners().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualGatewaySpecListener.Companion.toKotlin(args0)
                })
            }),
            loggings = javaType.loggings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualGatewaySpecLogging.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
