@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getVirtualNode.
 * @property arn ARN of the virtual node.
 * @property createdDate Creation date of the virtual node.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property lastUpdatedDate Last update date of the virtual node.
 * @property meshName
 * @property meshOwner
 * @property name
 * @property resourceOwner Resource owner's AWS account ID.
 * @property specs Virtual node specification. See the `aws.appmesh.VirtualNode` resource for details.
 * @property tags Map of tags.
 */
public data class GetVirtualNodeResult(
    public val arn: String,
    public val createdDate: String,
    public val id: String,
    public val lastUpdatedDate: String,
    public val meshName: String,
    public val meshOwner: String,
    public val name: String,
    public val resourceOwner: String,
    public val specs: List<GetVirtualNodeSpec>,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.GetVirtualNodeResult):
            GetVirtualNodeResult = GetVirtualNodeResult(
            arn = javaType.arn(),
            createdDate = javaType.createdDate(),
            id = javaType.id(),
            lastUpdatedDate = javaType.lastUpdatedDate(),
            meshName = javaType.meshName(),
            meshOwner = javaType.meshOwner(),
            name = javaType.name(),
            resourceOwner = javaType.resourceOwner(),
            specs = javaType.specs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualNodeSpec.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
