@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property backendDefaults
 * @property backends
 * @property listeners
 * @property loggings
 * @property serviceDiscoveries
 */
public data class GetVirtualNodeSpec(
    public val backendDefaults: List<GetVirtualNodeSpecBackendDefault>,
    public val backends: List<GetVirtualNodeSpecBackend>,
    public val listeners: List<GetVirtualNodeSpecListener>,
    public val loggings: List<GetVirtualNodeSpecLogging>,
    public val serviceDiscoveries: List<GetVirtualNodeSpecServiceDiscovery>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.GetVirtualNodeSpec):
            GetVirtualNodeSpec = GetVirtualNodeSpec(
            backendDefaults = javaType.backendDefaults().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualNodeSpecBackendDefault.Companion.toKotlin(args0)
                })
            }),
            backends = javaType.backends().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualNodeSpecBackend.Companion.toKotlin(args0)
                })
            }),
            listeners = javaType.listeners().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualNodeSpecListener.Companion.toKotlin(args0)
                })
            }),
            loggings = javaType.loggings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualNodeSpecLogging.Companion.toKotlin(args0)
                })
            }),
            serviceDiscoveries = javaType.serviceDiscoveries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualNodeSpecServiceDiscovery.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
