@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property connectionPools
 * @property healthChecks
 * @property outlierDetections
 * @property portMappings
 * @property timeouts
 * @property tls
 */
public data class GetVirtualNodeSpecListener(
    public val connectionPools: List<GetVirtualNodeSpecListenerConnectionPool>,
    public val healthChecks: List<GetVirtualNodeSpecListenerHealthCheck>,
    public val outlierDetections: List<GetVirtualNodeSpecListenerOutlierDetection>,
    public val portMappings: List<GetVirtualNodeSpecListenerPortMapping>,
    public val timeouts: List<GetVirtualNodeSpecListenerTimeout>,
    public val tls: List<GetVirtualNodeSpecListenerTl>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.GetVirtualNodeSpecListener):
            GetVirtualNodeSpecListener = GetVirtualNodeSpecListener(
            connectionPools = javaType.connectionPools().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualNodeSpecListenerConnectionPool.Companion.toKotlin(args0)
                })
            }),
            healthChecks = javaType.healthChecks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualNodeSpecListenerHealthCheck.Companion.toKotlin(args0)
                })
            }),
            outlierDetections = javaType.outlierDetections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualNodeSpecListenerOutlierDetection.Companion.toKotlin(args0)
                })
            }),
            portMappings = javaType.portMappings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualNodeSpecListenerPortMapping.Companion.toKotlin(args0)
                })
            }),
            timeouts = javaType.timeouts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualNodeSpecListenerTimeout.Companion.toKotlin(args0)
                })
            }),
            tls = javaType.tls().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualNodeSpecListenerTl.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
